/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.global_inbox;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.preferences.ConfigServicePreferenceStore;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import ch.elexis.global_inbox.ui.Messages;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class Preferences
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String PREFERENCE_BRANCH = "plugins/global_inbox/";
    public static final String PREF_DIR = "plugins/global_inbox/dir";
    public static final String PREF_AUTOBILLING = "plugins/global_inbox/autobilling";
    public static final String PREF_INFO_IN_INBOX = "plugins/global_inbox/infoToInbox";
    public static final String PREF_DIR_DEFAULT = "";
    public static final String PREF_TITLE_COMPLETION = "plugins/global_inbox/titleCompletions";
    public static final String STOREFSGLOBAL = "plugins/global_inbox/store_in_fs_global";
    private IPreferenceStore fsSettingsStore;
    private BooleanFieldEditor bStoreFSGlobal;
    private DirectoryFieldEditor dirFieldEditor;

    public Preferences() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)new SettingsPreferenceStore(CoreHub.localCfg));
    }

    protected void createFieldEditors() {
        this.bStoreFSGlobal = new BooleanFieldEditor(STOREFSGLOBAL, "Dateisystem Einstellungen global speichern", this.getFieldEditorParent()){

            protected void fireValueChanged(String property, Object oldValue, Object newValue) {
                super.fireValueChanged(property, oldValue, newValue);
                ConfigServiceHolder.get().set(Preferences.STOREFSGLOBAL, ((Boolean)newValue).booleanValue());
                Preferences.this.updateFSSettingsStore();
            }
        };
        this.addField((FieldEditor)this.bStoreFSGlobal);
        this.dirFieldEditor = new DirectoryFieldEditor(PREF_DIR, Messages.Preferences_directory, this.getFieldEditorParent());
        BooleanFieldEditor bAutomaticBilling = new BooleanFieldEditor(PREF_AUTOBILLING, "Automatische Verrechnung bei import", this.getFieldEditorParent());
        this.addField((FieldEditor)bAutomaticBilling);
        BooleanFieldEditor bInfoToInbox = new BooleanFieldEditor(PREF_INFO_IN_INBOX, "Vorselektion Info am Stammarzt", this.getFieldEditorParent());
        this.addField((FieldEditor)bInfoToInbox);
        this.dirFieldEditor.getTextControl(this.getFieldEditorParent()).setEditable(false);
        this.addField((FieldEditor)this.dirFieldEditor);
        this.updateFSSettingsStore();
    }

    private void updateFSSettingsStore() {
        boolean isGlobal = ConfigServiceHolder.getGlobal((String)STOREFSGLOBAL, (boolean)false);
        if (isGlobal) {
            this.fsSettingsStore = new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.GLOBAL);
            this.dirFieldEditor.getTextControl(this.getFieldEditorParent()).setEditable(true);
        } else {
            this.fsSettingsStore = this.getPreferenceStore();
            this.dirFieldEditor.getTextControl(this.getFieldEditorParent()).setEditable(false);
        }
        this.bStoreFSGlobal.setPreferenceStore(this.fsSettingsStore);
        this.bStoreFSGlobal.load();
        this.dirFieldEditor.setPreferenceStore(this.fsSettingsStore);
        this.dirFieldEditor.load();
    }

    public void init(IWorkbench workbench) {
    }
}

