/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.global_inbox.ui.handler;

import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.IContextService;
import ch.elexis.global_inbox.model.GlobalInboxEntry;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectToolItem;
import org.eclipse.e4.ui.workbench.modeling.EModelService;

public class AutoSelectPatientHandler {
    @Inject
    private IContextService contextService;
    private boolean isActive;

    @Inject
    public void initialize(EModelService modelService, MPart part) {
        MUIElement toolItem = modelService.find("ch.elexis.global_inbox.directtoolitem.autoSelectPatient", (MUIElement)part.getToolbar());
        this.isActive = ((MDirectToolItem)toolItem).isSelected();
    }

    @Execute
    public void execute(MDirectToolItem toolItem) {
        this.isActive = toolItem.isSelected();
    }

    @Inject
    public void setGlobalInboxEntry(@Optional @Named(value="org.eclipse.ui.selection") GlobalInboxEntry globalInboxEntry) {
        IPatient patient;
        if (globalInboxEntry == null) {
            return;
        }
        if (this.isActive && (patient = globalInboxEntry.getPatient()) != null) {
            this.contextService.getRootContext().setTyped((Object)patient);
        }
    }
}

