/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.global_inbox.preferencepage;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.global_inbox.preferencepage.CategoryEditingSupport;
import ch.elexis.global_inbox.preferencepage.TitleEditingSupport;
import ch.elexis.global_inbox.preferencepage.TitleEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TitleCompletionPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Table table;
    private TableViewer tableViewer;
    private List<TitleEntry> storedCompletions;
    static final String STORE_SEPARATOR = "|";

    public void init(IWorkbench workbench) {
        this.storedCompletions = ConfigServiceHolder.get().getAsList("plugins/global_inbox/titleCompletions", new ArrayList()).stream().map(val -> new TitleEntry((String)val)).collect(Collectors.toList());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        TableColumnLayout tcl_composite = new TableColumnLayout();
        composite.setLayout((Layout)tcl_composite);
        this.tableViewer = new TableViewer(composite, 68096);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableViewerColumn tvcTitle = new TableViewerColumn(this.tableViewer, 0);
        tvcTitle.setEditingSupport((EditingSupport)new TitleEditingSupport(this.tableViewer));
        tvcTitle.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((TitleEntry)element).getTitle();
            }
        });
        TableColumn tbclmTitle = tvcTitle.getColumn();
        tcl_composite.setColumnData((Widget)tbclmTitle, (ColumnLayoutData)new ColumnWeightData(80, 100, true));
        tbclmTitle.setText("Titel");
        TableViewerColumn tvcCategory = new TableViewerColumn(this.tableViewer, 0);
        tvcCategory.setEditingSupport((EditingSupport)new CategoryEditingSupport(this.tableViewer));
        tvcCategory.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((TitleEntry)element).getCategoryName();
            }
        });
        TableColumn tblclmCategory = tvcCategory.getColumn();
        tcl_composite.setColumnData((Widget)tblclmCategory, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmCategory.setText("Kategorie");
        final Menu popupMenu = new Menu((Control)this.table);
        this.table.setMenu(popupMenu);
        popupMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                popupMenu.getItem(1).setEnabled(TitleCompletionPreferencePage.this.tableViewer.getStructuredSelection().getFirstElement() != null);
            }
        });
        MenuItem mntmAdd = new MenuItem(popupMenu, 0);
        mntmAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TitleEntry titleEntry = new TitleEntry();
                TitleCompletionPreferencePage.this.storedCompletions.add(titleEntry);
                TitleCompletionPreferencePage.this.tableViewer.add((Object)titleEntry);
            }
        });
        mntmAdd.setText(Messages.Core_Add);
        mntmAdd.setImage(Images.IMG_ADD.getImage());
        MenuItem mntmDelete = new MenuItem(popupMenu, 0);
        mntmDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TitleEntry selection = (TitleEntry)TitleCompletionPreferencePage.this.tableViewer.getStructuredSelection().getFirstElement();
                if (selection != null) {
                    TitleCompletionPreferencePage.this.storedCompletions.remove(selection);
                }
                TitleCompletionPreferencePage.this.tableViewer.remove((Object)selection);
            }
        });
        mntmDelete.setText(Messages.Core_Delete);
        mntmDelete.setImage(Images.IMG_DELETE.getImage());
        this.tableViewer.setInput(this.storedCompletions);
        return composite;
    }

    protected void performApply() {
        List completions = this.storedCompletions.stream().map(le -> le.getTitle() + STORE_SEPARATOR + le.getCategoryName()).collect(Collectors.toList());
        ConfigServiceHolder.setGlobalAsList((String)"plugins/global_inbox/titleCompletions", completions);
        super.performApply();
    }
}

