/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.global_inbox.core.handler;

import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.VirtualFilesystemServiceHolder;
import ch.elexis.global_inbox.core.util.ImportOmnivoreInboxUtil;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportOmnivore {
    private final Pattern PATIENT_MATCH_PATTERN = Pattern.compile("([0-9]+)_(.+)");
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private ImportOmnivoreInboxUtil giutil = new ImportOmnivoreInboxUtil();
    private String deviceName;

    public ImportOmnivore(String deviceName) {
        this.deviceName = deviceName;
    }

    protected IStatus run(IProgressMonitor monitor) {
        String filepath = ImportOmnivoreInboxUtil.getDirectory("", this.deviceName);
        IVirtualFilesystemService.IVirtualFilesystemHandle dir = null;
        if (filepath == null) {
            filepath = "";
            ConfigServiceHolder.get().set("plugins/global_inbox_server/dir", "");
        }
        try {
            dir = VirtualFilesystemServiceHolder.get().of(filepath);
            this.addFilesInDirRecursive(dir);
        }
        catch (Exception e) {
            this.log.error("Failed to convert filepath to directory. Filepath: {}", (Object)filepath, (Object)e);
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private void addFilesInDirRecursive(IVirtualFilesystemService.IVirtualFilesystemHandle dir) throws IOException {
        IVirtualFilesystemService.IVirtualFilesystemHandle[] files = dir.listHandles();
        if (files == null) {
            return;
        }
        IVirtualFilesystemService.IVirtualFilesystemHandle[] iVirtualFilesystemHandleArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualFilesystemService.IVirtualFilesystemHandle file = iVirtualFilesystemHandleArray[n2];
            if (file.exists() && !file.getName().startsWith(".")) {
                if (file.isDirectory()) {
                    this.addFilesInDirRecursive(file);
                } else {
                    String fileName;
                    String patientNo;
                    String tryImportForPatient;
                    Matcher matcher = this.PATIENT_MATCH_PATTERN.matcher(file.getName());
                    if (matcher.matches() && (tryImportForPatient = this.giutil.tryImportForPatient(file, patientNo = matcher.group(1), fileName = matcher.group(2))) != null) {
                        this.log.info("Auto imported file [{}], document id is [{}]", (Object)file, (Object)tryImportForPatient);
                    }
                }
            }
            ++n2;
        }
    }
}

