/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.fop.service.config;

import ch.elexis.core.data.util.PlatformHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConfigFile {
    Element root;
    Document doc;

    public Element getRootElement() {
        return this.root;
    }

    public ConfigFile() {
        try {
            File fonts = new File(PlatformHelper.getBasePath((String)"ch.elexis.fop.service"), "rsc/fonts");
            DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
            this.doc = docBuilder.newDocument();
            this.root = this.doc.createElement("fop");
            this.root.setAttribute("version", "1.0");
            this.doc.appendChild(this.root);
            Element renderers = this.doc.createElement("renderers");
            this.root.appendChild(renderers);
            Element rendererPDF = this.doc.createElement("renderer");
            rendererPDF.setAttribute("mime", "application/pdf");
            Element rendererPS = this.doc.createElement("renderer");
            rendererPS.setAttribute("mime", "application/postscript");
            rendererPS.appendChild(this.getPsVersionElement());
            rendererPDF.appendChild(this.getFontsDirectoryElement(fonts));
            renderers.appendChild(rendererPDF);
            renderers.appendChild(rendererPS);
        }
        catch (ParserConfigurationException e) {
            LoggerFactory.getLogger(ConfigFile.class).error("Error during FOP configuration.", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private Node getPsVersionElement() {
        Element ret = this.doc.createElement("language-level");
        ret.setTextContent("2");
        return ret;
    }

    private Element getFontsDirectoryElement(File fonts) {
        Element ret = this.doc.createElement("fonts");
        Element autodetect = this.doc.createElement("auto-detect");
        Element directory = this.doc.createElement("directory");
        directory.setAttribute("recursive", "true");
        directory.setTextContent(fonts.getAbsolutePath());
        ret.appendChild(directory.cloneNode(true));
        ret.appendChild(autodetect.cloneNode(true));
        return ret;
    }

    private Element getType1Fonts(File fonts) {
        Element ret = this.doc.createElement("fonts");
        Element font = this.doc.createElement("font");
        font.setAttribute("kerning", "yes");
        font.setAttribute("embed-url", "file:/" + fonts.getAbsolutePath() + File.separator + "Ocr" + File.separator + "OCRA.pfb");
        Element fontTriple = this.doc.createElement("font-triplet");
        fontTriple.setAttribute("name", "OCRA");
        fontTriple.setAttribute("style", "normal");
        fontTriple.setAttribute("weight", "normal");
        font.appendChild(fontTriple.cloneNode(true));
        ret.appendChild(font.cloneNode(true));
        font = this.doc.createElement("font");
        font.setAttribute("kerning", "yes");
        font.setAttribute("embed-url", "file:/" + fonts.getAbsolutePath() + File.separator + "Ocr" + File.separator + "OCRB.pfb");
        fontTriple.setAttribute("name", "OCRB");
        fontTriple.setAttribute("style", "normal");
        fontTriple.setAttribute("weight", "normal");
        font.appendChild(fontTriple.cloneNode(true));
        ret.appendChild(font.cloneNode(true));
        return ret;
    }

    private String getAsString() {
        try {
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("indent", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(this.doc);
            trans.transform(source, result);
            return sw.toString();
        }
        catch (TransformerException e) {
            LoggerFactory.getLogger(ConfigFile.class).error("Error during FOP configuration.", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public String outputElement() {
        return this.getAsString();
    }

    public InputStream getAsInputStream() {
        return new ByteArrayInputStream(this.getAsString().getBytes());
    }
}

