/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.fop.service;

import ch.elexis.core.services.IFormattedOutput;
import ch.elexis.core.services.IFormattedOutputFactory;
import ch.elexis.fop.service.config.ConfigFile;
import ch.elexis.fop.service.dom.DomToPdf;
import ch.elexis.fop.service.dom.DomToPng;
import ch.elexis.fop.service.dom.DomToPs;
import ch.elexis.fop.service.jaxb.JaxbToPcl;
import ch.elexis.fop.service.jaxb.JaxbToPdf;
import ch.elexis.fop.service.jaxb.JaxbToPng;
import ch.elexis.fop.service.jaxb.JaxbToPs;
import ch.elexis.fop.service.xmlstream.XmlStreamToPcl;
import ch.elexis.fop.service.xmlstream.XmlStreamToPdf;
import ch.elexis.fop.service.xmlstream.XmlStreamToPng;
import ch.elexis.fop.service.xmlstream.XmlStreamToPs;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedMap;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FopConfParser;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.fop.tools.fontlist.FontListGenerator;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@Component
public class FormattedOutputFactory
implements IFormattedOutputFactory {
    private static FopFactory fopFactory;

    @Activate
    public void activate() {
        FormattedOutputFactory.initialize();
    }

    public IFormattedOutput getFormattedOutputImplementation(IFormattedOutputFactory.ObjectType objectType, IFormattedOutputFactory.OutputType outputType) {
        if (objectType == IFormattedOutputFactory.ObjectType.JAXB) {
            switch (outputType) {
                case PCL: {
                    return JaxbToPcl.getInstance();
                }
                case PDF: {
                    return JaxbToPdf.getInstance();
                }
                case PS: {
                    return JaxbToPs.getInstance();
                }
                case PNG: {
                    return JaxbToPng.getInstance();
                }
            }
        } else if (objectType == IFormattedOutputFactory.ObjectType.DOM) {
            switch (outputType) {
                case PDF: {
                    return DomToPdf.getInstance();
                }
                case PS: {
                    return DomToPs.getInstance();
                }
                case PNG: {
                    return DomToPng.getInstance();
                }
                case PCL: {
                    break;
                }
            }
        } else if (objectType == IFormattedOutputFactory.ObjectType.XMLSTREAM) {
            switch (outputType) {
                case PDF: {
                    return XmlStreamToPdf.getInstance();
                }
                case PS: {
                    return XmlStreamToPs.getInstance();
                }
                case PNG: {
                    return XmlStreamToPng.getInstance();
                }
                case PCL: {
                    return XmlStreamToPcl.getInstance();
                }
            }
        }
        throw new IllegalStateException("No IFormattedOutput implementation for [" + String.valueOf(objectType) + "->" + String.valueOf(outputType) + "]");
    }

    public static String[] getRegisteredFonts(String mimeType) {
        try {
            LinkedList<String> fontFamiliesList = new LinkedList<String>();
            FontListGenerator listGenerator = new FontListGenerator();
            SortedMap fontFamilies = listGenerator.listFonts(fopFactory, mimeType, null);
            for (Map.Entry entry : fontFamilies.entrySet()) {
                fontFamiliesList.add((String)entry.getKey());
            }
            return fontFamiliesList.toArray(new String[0]);
        }
        catch (FOPException e) {
            LoggerFactory.getLogger(FormattedOutputFactory.class).error("Error getting fonts", (Throwable)e);
            return new String[]{""};
        }
    }

    public static void initialize() {
        try {
            FopConfParser parser = new FopConfParser(new ConfigFile().getAsInputStream(), new URI("http://dummy.domain"));
            FopFactoryBuilder builder = parser.getFopFactoryBuilder();
            builder.setStrictFOValidation(false);
            fopFactory = builder.build();
        }
        catch (IOException | URISyntaxException | SAXException e) {
            LoggerFactory.getLogger(FormattedOutputFactory.class).error("Error initializing", (Throwable)e);
        }
    }

    public static FopFactory getFopFactory() {
        return fopFactory;
    }
}

