/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.fire.ui;

import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.tasks.model.ITaskDescriptor;
import ch.elexis.core.tasks.model.ITaskService;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.fire.core.IFIREService;
import ch.elexis.fire.core.task.FIREExportTaskDescriptor;
import jakarta.inject.Inject;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.slf4j.LoggerFactory;

public class FirePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    @Inject
    private IFIREService fireService;
    @Inject
    private ITaskService taskService;
    @Inject
    private IConfigService configService;
    @Inject
    private IContextService contextService;
    private ITaskDescriptor taskDescriptor;
    private Label synchInfo;
    boolean initialExportDone;

    public void init(IWorkbench workbench) {
        CoreUiUtil.injectServices((Object)((Object)this));
        try {
            this.taskDescriptor = FIREExportTaskDescriptor.getOrCreate((ITaskService)this.taskService);
        }
        catch (TaskException e) {
            this.setErrorMessage(e.getMessage());
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Could not init taskDescriptor", (Throwable)e);
        }
        this.initialExportDone = false;
    }

    protected Control createContents(Composite parent) {
        LocalDateTime localDateTime;
        Instant instant;
        Composite area = new Composite(parent, 0);
        area.setLayout((Layout)new GridLayout());
        StringBuilder sb = new StringBuilder();
        if (this.fireService.getInitialTimestamp() != -1L) {
            this.initialExportDone = true;
            instant = Instant.ofEpochMilli(this.fireService.getInitialTimestamp());
            localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
            sb.append("Der initiale Export war am " + DateTimeFormatter.ofPattern("dd.MM.yyyy").format(localDateTime) + " um " + DateTimeFormatter.ofPattern("HH:mm").format(localDateTime));
        } else {
            sb.append("Noch kein initialier Export.");
        }
        sb.append("\n");
        if (this.fireService.getIncrementalTimestamp() != -1L) {
            instant = Instant.ofEpochMilli(this.fireService.getIncrementalTimestamp());
            localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
            sb.append("Der letzte inkrementelle Export war am " + DateTimeFormatter.ofPattern("dd.MM.yyyy").format(localDateTime) + " um " + DateTimeFormatter.ofPattern("HH:mm").format(localDateTime));
        } else {
            sb.append("Noch kein inkrementeller Export.");
        }
        this.synchInfo = new Label(area, 0);
        this.synchInfo.setText(sb.toString());
        Label separator = new Label(area, 256);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.verticalIndent = 10;
        separator.setLayoutData((Object)gd);
        final Button automaticExport = new Button(area, 32);
        automaticExport.setText("Auf dieser Station automatisch an FIRE \u00fcbermitteln.");
        automaticExport.setSelection(this.contextService.getStationIdentifier().equals(this.configService.get("ch.elexis.fire/automaticexport/scheduledstation", null)));
        automaticExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (automaticExport.getSelection()) {
                    FirePreferencePage.this.configService.set("ch.elexis.fire/automaticexport/scheduledstation", FirePreferencePage.this.contextService.getStationIdentifier());
                } else {
                    FirePreferencePage.this.configService.set("ch.elexis.fire/automaticexport/scheduledstation", null);
                }
            }
        });
        area.layout();
        return area;
    }
}

