/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.fire.ui.export.internal;

import ch.elexis.core.model.IUser;
import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.tasks.model.ITask;
import ch.elexis.core.tasks.model.ITaskDescriptor;
import ch.elexis.core.tasks.model.ITaskService;
import ch.elexis.core.tasks.model.TaskState;
import ch.elexis.core.tasks.model.TaskTriggerType;
import ch.elexis.fire.core.IFIREService;
import ch.elexis.fire.core.task.FIREExportTaskDescriptor;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collections;
import java.util.TimerTask;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.slf4j.LoggerFactory;

public class AutomaticExportTask
extends TimerTask {
    public static final String SCHEDULED_STATION = "ch.elexis.fire/automaticexport/scheduledstation";
    public static final String SCHEDULESHOUR_CONFIG = "ch.elexis.fire/automaticexport/scheduledhour";
    private boolean shutdownRegistered;
    private boolean running;
    private IFIREService fireService;
    private IConfigService configService;
    private IContextService contextService;
    private ITaskService taskService;
    private ITaskDescriptor taskDescriptor;

    public AutomaticExportTask(IFIREService fireService, ITaskService taskService, IConfigService configService, IContextService contextService) {
        this.fireService = fireService;
        this.configService = configService;
        this.contextService = contextService;
        this.taskService = taskService;
        try {
            this.taskDescriptor = FIREExportTaskDescriptor.getOrCreate((ITaskService)taskService);
        }
        catch (TaskException e) {
            LoggerFactory.getLogger(this.getClass()).error("Could not init taskDescriptor", (Throwable)e);
        }
    }

    @Override
    public void run() {
        if (!this.shutdownRegistered) {
            this.shutdownRegistered = true;
            PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

                public boolean preShutdown(IWorkbench workbench, boolean forced) {
                    if (AutomaticExportTask.this.contextService.getStationIdentifier().equals(AutomaticExportTask.this.configService.get(AutomaticExportTask.SCHEDULED_STATION, null))) {
                        return MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Warnung", (String)"Diese Elexis Instanz soll automatisch an FIRE \u00fcbermitteln. Wollen Sie trotzdem beenden?");
                    }
                    return true;
                }

                public void postShutdown(IWorkbench workbench) {
                }
            });
        }
        if (!this.running && this.contextService.getStationIdentifier().equals(this.configService.get(SCHEDULED_STATION, null)) && !this.wasScheduledToday() && this.isAfterScheduledHour()) {
            Job job = new Job(this.initialExportDone(this.fireService) ? "FIRE inkrementeller Export" : "FIRE initialer Export"){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask("FIRE Export", -1);
                    try {
                        ITask task;
                        AutomaticExportTask.this.running = true;
                        if (AutomaticExportTask.this.taskDescriptor.getOwner() == null) {
                            AutomaticExportTask.this.taskDescriptor.setOwner((IUser)ContextServiceHolder.get().getActiveUser().get());
                            AutomaticExportTask.this.taskService.saveTaskDescriptor(AutomaticExportTask.this.taskDescriptor);
                        }
                        if ((task = AutomaticExportTask.this.taskService.triggerSync(AutomaticExportTask.this.taskDescriptor, monitor, TaskTriggerType.MANUAL, Collections.emptyMap())).getState() == TaskState.COMPLETED || task.getState() == TaskState.COMPLETED_MANUAL || task.getState() == TaskState.COMPLETED_WARN) {
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                    }
                    catch (TaskException e) {
                        LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error performing FIRE export", (Throwable)e);
                        Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Der Export ist fehlgeschlagen."));
                    }
                    finally {
                        AutomaticExportTask.this.running = false;
                    }
                    return Status.CANCEL_STATUS;
                }
            };
            job.schedule();
        }
    }

    private boolean initialExportDone(IFIREService fireService) {
        return fireService.getInitialTimestamp() != -1L;
    }

    private boolean wasScheduledToday() {
        return this.getTimestampOfLastExport(this.fireService).toLocalDate().equals(LocalDate.now());
    }

    private LocalDateTime getTimestampOfLastExport(IFIREService fireService) {
        if (fireService.getIncrementalTimestamp() != -1L) {
            Instant instant = Instant.ofEpochMilli(fireService.getIncrementalTimestamp());
            return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        }
        if (fireService.getInitialTimestamp() != -1L) {
            Instant instant = Instant.ofEpochMilli(fireService.getInitialTimestamp());
            return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        }
        return LocalDateTime.of(1970, 1, 1, 0, 0);
    }

    private boolean isAfterScheduledHour() {
        return this.getScheduledHour() <= LocalDateTime.now().getHour();
    }

    private Integer getScheduledHour() {
        int configuredValue = ConfigServiceHolder.get().get(SCHEDULESHOUR_CONFIG, 1);
        return configuredValue;
    }
}

