/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.fire.core.task;

import ch.elexis.core.model.tasks.IIdentifiedRunnable;
import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.fire.core.IFIREService;
import java.io.File;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;

public class FIREExportIdentifiedRunnable
implements IIdentifiedRunnable {
    public static final String RUNNABLE_ID = "fireExport";
    public static final String DESCRIPTION = "Perform FIRE (USZ) export and upload, if initial was performed incremental is performed";
    private IFIREService fireService;
    private int uploaded;
    private int uploadFailed;
    private Logger logger;

    public FIREExportIdentifiedRunnable(IFIREService fireService) {
        this.fireService = fireService;
    }

    public String getId() {
        return RUNNABLE_ID;
    }

    public String getLocalizedDescription() {
        return DESCRIPTION;
    }

    public Map<String, Serializable> getDefaultRunContext() {
        HashMap<String, Serializable> defaultRunContext = new HashMap<String, Serializable>();
        return defaultRunContext;
    }

    public Map<String, Serializable> run(Map<String, Serializable> runContext, IProgressMonitor progressMonitor, Logger logger) throws TaskException {
        Instant instant;
        this.logger = logger;
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>();
        this.uploaded = 0;
        this.uploadFailed = 0;
        LocalDateTime initialLocalDateTime = null;
        LocalDateTime incrementalLocalDateTime = null;
        if (this.fireService.getInitialTimestamp() != -1L) {
            instant = Instant.ofEpochMilli(this.fireService.getInitialTimestamp());
            initialLocalDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        }
        if (this.fireService.getIncrementalTimestamp() != -1L) {
            instant = Instant.ofEpochMilli(this.fireService.getInitialTimestamp());
            incrementalLocalDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        }
        boolean cancelled = false;
        List<File> exported = null;
        if (initialLocalDateTime == null) {
            logger.info("Starting initial FIRE export");
            exported = this.fireService.initialExport(progressMonitor);
        } else {
            logger.info("Last Export was " + (incrementalLocalDateTime == null ? initialLocalDateTime.toString() : incrementalLocalDateTime.toString()) + "Starting incremental FIRE export");
            exported = this.fireService.incrementalExport(incrementalLocalDateTime == null ? this.fireService.getInitialTimestamp() : this.fireService.getIncrementalTimestamp(), progressMonitor);
        }
        cancelled = progressMonitor.isCanceled();
        if (exported != null && !exported.isEmpty()) {
            logger.info("Exported [" + exported.size() + "] files");
            Collection foundUploadFiles = FileUtils.listFiles((File)exported.get(0).getParentFile(), (String[])new String[]{"json"}, (boolean)false);
            logger.info("Found [" + foundUploadFiles.size() + "] files for upload in [" + exported.get(0).getParentFile().getPath() + "]");
            foundUploadFiles.forEach(f -> {
                if (this.fireService.uploadBundle((File)f)) {
                    ++this.uploaded;
                    logger.info("Upload [" + f.getAbsolutePath() + "] successful");
                    f.delete();
                } else {
                    ++this.uploadFailed;
                    logger.warn("Upload [" + f.getAbsolutePath() + "] failed");
                }
            });
        } else {
            logger.warn("No exported files");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("FIRE Export: ").append(initialLocalDateTime == null ? "initial" : "incremental").append(" finished ").append(this.uploaded).append(" files uploaded ").append(this.uploadFailed).append(" files upload failed.");
        if (cancelled) {
            sb.append("\nFIRE Export was cancelled.");
        }
        resultMap.put("resultData", (Serializable)((Object)sb.toString()));
        return resultMap;
    }
}

