/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.fire.core.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.LoggerFactory;

public class FIREUploadBundle
implements Supplier<Boolean> {
    private static final String UPLOAD_URL = "https://fire.ihamz.uzh.ch";
    private File file;

    public FIREUploadBundle(File file) {
        this.file = file;
    }

    @Override
    public Boolean get() {
        File tempBundleFile = null;
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpPost httppost = new HttpPost("https://fire.ihamz.uzh.ch/fire/index.php");
            httppost.setHeader("Authorization", this.getAuth());
            FileBody bundleBody = new FileBody(this.file, ContentType.APPLICATION_JSON);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setCharset(StandardCharsets.UTF_8);
            builder.addPart("files[]", (ContentBody)bundleBody);
            HttpEntity uploadEntity = builder.build();
            httppost.setEntity(uploadEntity);
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            LoggerFactory.getLogger(this.getClass()).info("Got response code [" + response.getStatusLine().getStatusCode() + "] from [" + httppost.getURI().toString() + "]");
            if (response.getStatusLine().getStatusCode() == 200) {
                LoggerFactory.getLogger(this.getClass()).info("Bundle [" + this.file.getName() + "] uploaded successful");
                Boolean bl = Boolean.TRUE;
                return bl;
            }
            LoggerFactory.getLogger(this.getClass()).warn("Uploading bundle [" + this.file.getName() + "] failed");
            Boolean bl = Boolean.TRUE;
            return bl;
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Exception uploading bundle", (Throwable)e);
        }
        finally {
            if (tempBundleFile != null) {
                tempBundleFile.delete();
            }
        }
        return Boolean.FALSE;
    }

    private String getAuth() {
        InputStream rsc = this.getClass().getResourceAsStream("/rsc/upload");
        if (rsc != null) {
            try {
                String upload = IOUtils.toString((InputStream)rsc, (String)"UTF-8");
                String[] parts = upload.split(",");
                if (parts.length == 2) {
                    String credentials = parts[0] + ":" + parts[1];
                    return "Basic " + new String(Base64.encodeBase64((byte[])credentials.getBytes()));
                }
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Exception reading upload", (Throwable)e);
            }
        }
        LoggerFactory.getLogger(this.getClass()).warn("No auth found");
        return "";
    }
}

