/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.extdoc.dialogs;

import ch.elexis.core.model.util.ElexisIdGenerator;
import ch.elexis.core.ui.actions.BackgroundJob;
import ch.elexis.core.ui.actions.JobPool;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Patient;
import ch.elexis.extdoc.Messages;
import ch.elexis.extdoc.dialogs.FileEditDialog;
import ch.elexis.extdoc.preferences.PreferenceConstants;
import ch.elexis.extdoc.util.MatchPatientToPath;
import java.io.File;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class VerifierDialog
extends TitleAreaDialog {
    private Patient actPatient;
    TableViewer viewer;
    BackgroundJob globalJob;

    public VerifierDialog(Shell parent, Patient patient) {
        super(parent);
        this.actPatient = patient;
    }

    protected Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        composite.setLayout((Layout)new GridLayout());
        this.viewer = new TableViewer(parent, 66308);
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        TableColumn tc = new TableColumn(table, 16384);
        tc.setText("");
        tc.setWidth(40);
        tc = new TableColumn(table, 16384);
        tc.setText(Messages.ExterneDokumente_file_date);
        tc.setWidth(120);
        tc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
            }
        });
        tc = new TableColumn(table, 16384);
        tc.setText(Messages.VerifierDialog_name);
        tc.setWidth(200);
        tc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
            }
        });
        this.viewer.setContentProvider((IContentProvider)new VerifierContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new VerifierLabelProvider());
        this.viewer.setComparator((ViewerComparator)new TimestampComparator());
        this.viewer.setInput((Object)this);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element;
                StructuredSelection selection = (StructuredSelection)VerifierDialog.this.viewer.getSelection();
                if (selection != null && (element = selection.getFirstElement()) instanceof File) {
                    VerifierDialog.this.openFileEditorDialog((File)element);
                }
            }
        });
        return composite;
    }

    private void openFileEditorDialog(File file) {
        FileEditDialog fed = new FileEditDialog(this.getShell(), file);
        fed.open();
        this.refresh();
    }

    private void refresh() {
        this.globalJob.invalidate();
        this.viewer.refresh(true);
    }

    public void create() {
        super.create();
        this.setMessage(Messages.ExterneDokumente_verify_files_Belong_to_patient);
        this.setTitle(Messages.ExterneDokumente_verify_files);
        this.getShell().setText(Messages.ExterneDokumente_verify_files);
        this.setTitleImage(Images.IMG_LOGO.getImage());
    }

    class DataLoader
    extends BackgroundJob {
        public DataLoader(String jobName) {
            super(jobName);
        }

        public IStatus execute(IProgressMonitor monitor) {
            String[] paths = PreferenceConstants.getActiveBasePaths();
            this.result = VerifierDialog.this.actPatient != null ? MatchPatientToPath.getFilesForPatient(VerifierDialog.this.actPatient, null) : Messages.ExterneDokumente_no_patient_found;
            return Status.OK_STATUS;
        }

        public int getSize() {
            return 1;
        }
    }

    class TimestampComparator
    extends ViewerComparator {
        TimestampComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            long modified2;
            if (e1 == null) {
                return 1;
            }
            if (e2 == null) {
                return -1;
            }
            File file1 = (File)e1;
            File file2 = (File)e2;
            long modified1 = file1.lastModified();
            if (modified1 < (modified2 = file2.lastModified())) {
                return -1;
            }
            if (modified1 > modified2) {
                return 1;
            }
            return 0;
        }
    }

    class VerifierContentProvider
    implements IStructuredContentProvider,
    BackgroundJob.BackgroundJobListener {
        private String BASE_JOBNAME = Messages.VerifierDialog_verify_job_name;
        BackgroundJob job;

        public VerifierContentProvider() {
            String jobName = this.BASE_JOBNAME + " " + ElexisIdGenerator.generateId();
            VerifierDialog.this.globalJob = this.job = new DataLoader(jobName);
            if (JobPool.getJobPool().getJob(this.job.getJobname()) == null) {
                JobPool.getJobPool().addJob(this.job);
            }
            this.job.addListener((BackgroundJob.BackgroundJobListener)this);
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
            this.job.removeListener((BackgroundJob.BackgroundJobListener)this);
        }

        public Object[] getElements(Object parent) {
            Object result = this.job.getData();
            if (result == null) {
                JobPool.getJobPool().activate(this.job.getJobname(), 30);
                return new String[]{Messages.ExterneDokumente_loading};
            }
            if (result instanceof List) {
                return ((List)result).toArray();
            }
            if (result instanceof String) {
                return new Object[]{result};
            }
            return null;
        }

        public void jobFinished(BackgroundJob j) {
            VerifierDialog.this.viewer.refresh(true);
        }
    }

    class VerifierLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private static final int STATUS_COLUMN = 0;
        private static final int DATE_COLUMN = 1;
        private static final int NAME_COLUMN = 2;

        VerifierLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            switch (index) {
                case 1: {
                    return this.getDate(obj);
                }
                case 2: {
                    return this.getText(obj);
                }
            }
            return "";
        }

        public String getText(Object obj) {
            if (obj instanceof File) {
                File file = (File)obj;
                return file.getName();
            }
            if (obj instanceof String) {
                return obj.toString();
            }
            return "";
        }

        public String getDate(Object obj) {
            if (obj instanceof File) {
                File file = (File)obj;
                long modified = file.lastModified();
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(modified);
                String modifiedTime = DateFormat.getDateTimeInstance(3, 3).format(cal.getTime());
                return modifiedTime;
            }
            return "";
        }

        public Image getColumnImage(Object obj, int index) {
            switch (index) {
                case 0: {
                    return Images.IMG_FEHLER.getImage();
                }
                case 2: {
                    return this.getImage(obj);
                }
            }
            return null;
        }

        public Image getImage(Object obj) {
            if (!(obj instanceof File)) {
                return null;
            }
            File file = (File)obj;
            if (file.isDirectory()) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }
    }
}

