/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.extdoc.util;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.data.Patient;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Email {
    private static Logger logger = null;

    private static String enc(String p) {
        if (p == null) {
            p = "";
        }
        try {
            return URLEncoder.encode(p, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException();
        }
    }

    public static void saveTextToClipboard(String body) {
        Clipboard clipboard = new Clipboard(UiDesk.getDisplay());
        TextTransfer textTransfer = TextTransfer.getInstance();
        clipboard.setContents(new Object[]{body}, new Transfer[]{textTransfer});
        clipboard.dispose();
    }

    public static String getEmailPreface(Patient patient) {
        StringBuilder sb = new StringBuilder();
        sb.append(patient.getName() + " ");
        sb.append(patient.getVorname() + " ");
        sb.append(patient.getPostAnschrift(false) + " ");
        sb.append(patient.get("Telefon1") + " ");
        sb.append(patient.getNatel() + " ");
        sb.append(patient.getMailAddress() + " ");
        return sb.toString();
    }

    public static String getAllKonsultations(Patient patient) {
        StringBuilder sb = new StringBuilder();
        return sb.toString();
    }

    public static boolean onWindows() {
        return System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
    }

    public static void runExternalProgram(String app, String params) {
        String cmd = app + " " + params;
        logger.info(cmd);
        try {
            File temp = File.createTempFile("batch", ".cmd");
            BufferedWriter bw = new BufferedWriter(new FileWriter(temp));
            bw.write("\"" + app + "\" " + params);
            bw.close();
            temp.setExecutable(true);
            logger.info("will call " + temp.getAbsolutePath());
            if (Email.onWindows()) {
                Runtime.getRuntime().exec("cmd /c " + temp.getAbsolutePath());
            } else {
                Runtime.getRuntime().exec(temp.getAbsolutePath());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void openMailApplication(String to, String subject, String body, List<File> attachments) {
        logger = LoggerFactory.getLogger((String)"ch.elexis.extdoc");
        if (subject == null) {
            subject = CoreHub.localCfg.get("ch.elexis.externe_dokumente/Concerns", "\u00dcberweisung");
        }
        Object app = CoreHub.localCfg.get("ch.elexis.externe_dokumente/Email_app", "mailto:");
        Object params = "";
        try {
            if (((String)app).toLowerCase().indexOf("outlook") >= 0) {
                params = (String)params + " --composer --subject '" + subject + "'";
                if (attachments != null) {
                    for (File f : attachments) {
                        params = (String)params + " /a \"" + f.getAbsolutePath() + "\"";
                    }
                }
                if (to != null && to.length() > 0) {
                    params = (String)params + " " + to;
                }
                Email.runExternalProgram((String)app, (String)params);
            } else if (((String)app).toLowerCase().indexOf("kmail") >= 0) {
                params = (String)params + " --composer --subject '" + subject + "'";
                File temp = File.createTempFile("message", ".tmp");
                BufferedWriter bw = new BufferedWriter(new FileWriter(temp));
                bw.write(body);
                bw.close();
                params = (String)params + " --msg " + temp.getAbsolutePath();
                if (attachments != null) {
                    for (File f : attachments) {
                        params = (String)params + " --attach 'file://" + f.getAbsolutePath() + "'";
                    }
                }
                if (to != null && to.length() > 0) {
                    params = (String)params + " " + to;
                }
                Email.runExternalProgram((String)app, (String)params);
            } else if (((String)app).toLowerCase().indexOf("thunderbird") >= 0 || ((String)app).toLowerCase().indexOf("icedove") >= 0) {
                params = (String)params + " -compose \"";
                if (to != null && to.length() > 0) {
                    params = " to='" + to + "',";
                }
                params = (String)params + "subject=\"" + subject + "\"";
                params = (String)params + ",body='Bitte Ctrl-V benutzen, um Konsultationen einzuf\u00fcgen'";
                if (attachments != null && attachments.size() > 0) {
                    params = (String)params + ",attachment='";
                    for (File f : attachments) {
                        params = (String)params + "\"" + f.getAbsolutePath() + "\",";
                    }
                    params = ((String)params).substring(0, ((String)params).length() - 1);
                    params = (String)params + "'";
                }
                params = (String)params + "\"";
                Email.saveTextToClipboard(body);
                Email.runExternalProgram((String)app, (String)params);
            } else {
                app = to != null && to.length() > 0 ? (String)app + "?to=" + Email.enc(to) : (String)app + "?";
                app = (String)app + "subject=" + Email.enc(subject);
                app = (String)app + "&body=" + Email.enc(body);
                Email.saveTextToClipboard(body);
                Email.runExternalProgram((String)app, "");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

