/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.estudio.clustertec;

import ch.clustertec.estudio.schemas.order.Order;
import ch.clustertec.estudio.schemas.order.OrderResponse;
import ch.clustertec.estudio.schemas.prescription.Prescription;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.PropertyException;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class ClustertecJaxbUtil {
    public static final String JAXB_HEADER_KEY = "org.glassfish.jaxb.xmlHeaders";
    public static final String DEFAULT_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static Logger log = LoggerFactory.getLogger(ClustertecJaxbUtil.class);

    public static OrderResponse unmarshalOrderResponse(InputStream inStream) {
        try {
            Node attribute;
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{OrderResponse.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(inStream));
            Element root = document.getDocumentElement();
            NamedNodeMap attributes = root.getAttributes();
            int i = 0;
            while (i < attributes.getLength()) {
                attribute = attributes.item(i);
                if (attribute.getNodeName().equals("xsi:type")) {
                    attributes.removeNamedItem(attribute.getNodeName());
                }
                ++i;
            }
            i = 0;
            while (i < attributes.getLength()) {
                attribute = attributes.item(i);
                if (attribute.getNodeName().equals("xmlns:xsi")) {
                    attributes.removeNamedItem(attribute.getNodeName());
                }
                ++i;
            }
            root.setAttribute("xmlns", "http://estudio.clustertec.ch/schemas/order");
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(writer));
            return (OrderResponse)unmarshaller.unmarshal((Source)new StreamSource(new StringReader(writer.toString())));
        }
        catch (Exception e) {
            log.error("Unmarshalling OrderResponse failed", (Throwable)e);
            return null;
        }
    }

    public static boolean marshalOrder(Order clustertecOrder, OutputStream outStream) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Order.class});
            Marshaller marshaller = ClustertecJaxbUtil.initMarshaller(jaxbContext, "http://estudio.clustertec.ch/schemas/order.xsd", false);
            marshaller.marshal((Object)clustertecOrder, outStream);
            return true;
        }
        catch (JAXBException e) {
            log.error("Marshalling Order failed", (Throwable)e);
            return false;
        }
    }

    public static String marshalOrder(Order clustertecOrder) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ClustertecJaxbUtil.marshalOrder(clustertecOrder, out);
        return new String(out.toByteArray());
    }

    private static Marshaller initMarshaller(JAXBContext jaxbContext, String schemaLocation, boolean addDefaultHeader) throws JAXBException {
        Marshaller marshaller = jaxbContext.createMarshaller();
        try {
            marshaller.setProperty("jaxb.fragment", (Object)true);
            if (schemaLocation != null) {
                marshaller.setProperty("jaxb.schemaLocation", (Object)schemaLocation);
            }
            if (addDefaultHeader) {
                marshaller.setProperty(JAXB_HEADER_KEY, (Object)DEFAULT_HEADER);
            }
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            return marshaller;
        }
        catch (PropertyException propE) {
            log.error("Error setting marshall properties - concerns XML with schema [" + schemaLocation + "]", (Throwable)propE);
            return marshaller;
        }
    }

    public static String marshalPrescription(Prescription clustertecPrescription) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ClustertecJaxbUtil.marshalPrescription(clustertecPrescription, out);
        return new String(out.toByteArray());
    }

    public static boolean marshalPrescription(Prescription clustertecPrescription, OutputStream outStream) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Prescription.class});
            Marshaller marshaller = ClustertecJaxbUtil.initMarshaller(jaxbContext, "http://estudio.clustertec.ch/schemas/prescription.xsd", false);
            marshaller.marshal((Object)clustertecPrescription, outStream);
            return true;
        }
        catch (JAXBException e) {
            log.error("Marshalling Order failed", (Throwable)e);
            return false;
        }
    }
}

