/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ebanking.parser;

import ch.elexis.ebanking.parser.Camet054Exception;
import java.util.Date;

public class Camt054Record {
    private String amount;
    private String reference;
    private String tn;
    private Date bookingDate;
    private Date valuDate;
    private Date readDate;
    private String mode;

    public Camt054Record(String mode, String amount, String reference, String tn, Date readDate, Date bookingDate, Date valueDate) throws Camet054Exception {
        this.amount = amount;
        this.reference = reference;
        this.tn = tn;
        this.bookingDate = bookingDate;
        this.valuDate = valueDate;
        this.readDate = readDate;
        this.mode = mode;
        this.validate();
    }

    private void validate() throws Camet054Exception {
        try {
            if (Integer.parseInt(this.amount) < 0) {
                throw new Camet054Exception("amount is negativ: " + this.amount);
            }
        }
        catch (NumberFormatException e) {
            throw new Camet054Exception("amount not valid", e);
        }
        if (this.bookingDate != null && this.bookingDate.before(new Date(0L))) {
            throw new Camet054Exception("booking date is not valid: " + String.valueOf(this.bookingDate));
        }
        if (this.valuDate != null && this.valuDate.before(new Date(0L))) {
            throw new Camet054Exception("valu date is not valid: " + String.valueOf(this.valuDate));
        }
        if (this.readDate != null && this.readDate.before(new Date(0L))) {
            throw new Camet054Exception("read date is not valid: " + String.valueOf(this.readDate));
        }
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getMode() {
        return this.mode;
    }

    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getTn() {
        return this.tn;
    }

    public void setTn(String tn) {
        this.tn = tn;
    }

    public Date getBookingDate() {
        return this.bookingDate;
    }

    public Date getValuDate() {
        return this.valuDate;
    }

    public void setBookingDate(Date bookingDate) {
        this.bookingDate = bookingDate;
    }

    public void setValuDate(Date valuDate) {
        this.valuDate = valuDate;
    }

    public Date getReadDate() {
        return this.readDate;
    }

    public String toString() {
        return "Camt054Record [mode=" + this.mode + ", reference=" + this.reference + ", amount=" + this.amount + ", tn=" + this.tn + ", bookingDate=" + String.valueOf(this.bookingDate) + ", valuDate=" + String.valueOf(this.valuDate) + ", readDate=" + String.valueOf(this.readDate) + "]";
    }
}

