/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ebanking.qr;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.format.AddressFormatUtil;
import ch.elexis.core.types.Country;
import ch.elexis.ebanking.qr.QRBillDataException;
import ch.elexis.ebanking.qr.model.QRBillData;
import ch.rgw.tools.Money;
import java.lang.reflect.InvocationTargetException;
import java.util.StringJoiner;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;

public class QRBillDataBuilder {
    private String headerQRType = "SPC";
    private String headerVersion = "0200";
    private String headerCoding = "1";
    private IContact cdtrInfContact;
    private Money amount;
    private String amountCurrency;
    private IContact ultmtDbtrContact;
    private String referenceType;
    private String reference;
    private String referenceUnstructuredRemark;
    private String referenceTrailer;

    public QRBillDataBuilder(IContact cdtrInf, Money money, String currency, IContact ultmtDbtr) {
        this.cdtrInf(cdtrInf);
        this.amount(money, currency);
        this.ultmtDbtr(ultmtDbtr);
        this.referenceType = "NON";
        this.referenceTrailer = "EPD";
    }

    public QRBillDataBuilder cdtrInf(IContact contact) {
        this.cdtrInfContact = contact;
        return this;
    }

    public QRBillDataBuilder amount(Money money, String currency) {
        this.amount = money;
        this.amount.roundTo5();
        this.amountCurrency = currency;
        return this;
    }

    public QRBillDataBuilder ultmtDbtr(IContact contact) {
        this.ultmtDbtrContact = contact;
        return this;
    }

    public QRBillDataBuilder reference(String reference) {
        this.reference = reference;
        if (StringUtils.isNotBlank((CharSequence)reference)) {
            if (reference.length() == 27) {
                this.referenceType = "QRR";
            } else if (reference.length() <= 25) {
                this.referenceType = "SCOR";
            }
        }
        return this;
    }

    public QRBillDataBuilder unstructuredRemark(String remark) {
        this.referenceUnstructuredRemark = remark;
        return this;
    }

    public QRBillData build() throws QRBillDataException {
        QRBillData ret = new QRBillData();
        ret.setHeaderQRType(this.headerQRType);
        ret.setHeaderVersion(this.headerVersion);
        ret.setHeaderCoding(this.headerCoding);
        ret.setCdtrInfIBAN(StringUtils.defaultString((String)((String)this.cdtrInfContact.getExtInfo((Object)"IBAN"))));
        this.setAddress(ret, "cdtrInf", this.cdtrInfContact);
        ret.setCcyAmtAmt(String.format("%.2f", this.amount.getAmount()).replaceAll(",", "."));
        ret.setCcyAmtCcy(this.amountCurrency);
        this.setAddress(ret, "ultmtDbtr", this.ultmtDbtrContact);
        ret.setRmtInfTp(this.referenceType);
        ret.setRmtInfRef(this.reference);
        ret.setRmtInfUstrd(StringUtils.defaultString((String)this.referenceUnstructuredRemark).replaceAll("\\r|\\n", ""));
        ret.setRmtInfTrailer(this.referenceTrailer);
        return ret;
    }

    private void setAddress(QRBillData qrBillData, String prefix, IContact contact) throws QRBillDataException {
        try {
            BeanUtils.setProperty((Object)qrBillData, (String)(prefix + "AdrTp"), (Object)"S");
            BeanUtils.setProperty((Object)qrBillData, (String)(prefix + "Name"), (Object)AddressFormatUtil.getFullnameWithSalutation((IContact)contact).replaceAll("\n", " ").trim());
            System.out.println("");
            String street = this.getStreet(contact);
            String houseNr = this.getHouseNr(contact);
            BeanUtils.setProperty((Object)qrBillData, (String)(prefix + "StrtNmOrAdrLine1"), (Object)street);
            BeanUtils.setProperty((Object)qrBillData, (String)(prefix + "StrtNmOrAdrLine2"), (Object)StringUtils.left((String)houseNr, (int)16));
            String postalCode = contact.getZip().trim();
            String town = contact.getCity().trim();
            BeanUtils.setProperty((Object)qrBillData, (String)(prefix + "PstCd"), (Object)postalCode);
            BeanUtils.setProperty((Object)qrBillData, (String)(prefix + "TwnNm"), (Object)town);
            Country country = contact.getCountry();
            if (Country.NDF == country) {
                country = Country.CH;
            }
            BeanUtils.setProperty((Object)qrBillData, (String)(prefix + "Ctry"), (Object)StringUtils.left((String)country.toString(), (int)2));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof QRBillDataException) {
                ((QRBillDataException)cause).setContact(contact);
                throw (QRBillDataException)cause;
            }
            throw new QRBillDataException(QRBillDataException.SourceType.UNKNOWN, e.getMessage());
        }
    }

    private String getHouseNr(IContact contact) {
        String[] parts;
        String street = contact.getStreet().trim();
        if (StringUtils.isNotBlank((CharSequence)street) && (parts = street.split(" ")).length > 1 && Character.isDigit(parts[parts.length - 1].charAt(0))) {
            return parts[parts.length - 1];
        }
        return "";
    }

    private String getStreet(IContact contact) {
        String street = contact.getStreet().trim();
        if (StringUtils.isNotBlank((CharSequence)street)) {
            String[] parts = street.split(" ");
            if (parts.length > 1 && Character.isDigit(parts[parts.length - 1].charAt(0))) {
                StringJoiner sj = new StringJoiner(" ");
                int i = 0;
                while (i < parts.length - 1) {
                    sj.add(parts[i]);
                    ++i;
                }
                return sj.toString();
            }
            return street;
        }
        return "";
    }
}

