/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.covid.cert.service;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IDocumentStore;
import ch.elexis.covid.cert.service.CertificateInfo;
import ch.elexis.covid.cert.service.rest.CovidCertificateApi;
import ch.elexis.covid.cert.service.rest.model.RecoveryModel;
import ch.elexis.covid.cert.service.rest.model.RevokeModel;
import ch.elexis.covid.cert.service.rest.model.SuccessResponse;
import ch.elexis.covid.cert.service.rest.model.TestModel;
import ch.elexis.covid.cert.service.rest.model.VaccinationModel;
import ch.rgw.tools.Result;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.emf.ecore.xml.type.internal.DataValue;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component(service={CertificatesService.class})
public class CertificatesService {
    public static final String CFG_DEFAULT_VACCPRODUCT = "ch.elexis.covid.cert/default/vaccproductcode";
    public static final String CFG_DEFAULT_TESTPRODUCT = "ch.elexis.covid.cert/default/testproductcode";
    private static String CFG_MODE = "ch.elexis.covid.cert/mode";
    public static String CFG_TESTCENTERNAME = "ch.elexis.covid.cert/testcentername";
    public static String CFG_OTP = "ch.elexis.covid.cert/otp";
    public static String CFG_OTP_TIMESTAMP = "ch.elexis.covid.cert/otptimestamp";
    @Reference(target="(storeid=ch.elexis.data.store.omnivore)")
    private IDocumentStore omnivoreDocumentStore;
    @Reference
    private IConfigService configService;
    private CovidCertificateApi covidCertificateApi;
    private Properties keyProperties;

    @Activate
    private void activate() {
        InputStream propertiesStream = this.getClass().getResourceAsStream("/rsc/keys.properties");
        if (propertiesStream != null) {
            this.keyProperties = new Properties();
            try {
                this.keyProperties.load(propertiesStream);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error loading keys properties", (Throwable)e);
            }
        } else {
            LoggerFactory.getLogger(this.getClass()).error("No keys properties fragement available");
        }
        this.covidCertificateApi = new CovidCertificateApi(this.getMode(), this.keyProperties);
    }

    public boolean isOtpSet() {
        return this.configService.getActiveMandator(CFG_OTP, null) != null;
    }

    public String getOtp() {
        return this.configService.getActiveMandator(CFG_OTP, "");
    }

    public Result<String> createVaccinationCertificate(IPatient patient, VaccinationModel model) {
        Object result = this.covidCertificateApi.vaccination(model);
        if (result instanceof SuccessResponse) {
            try {
                String documentId = this.pdfToOmnivore(patient, CertificateInfo.Type.VACCINATION, (SuccessResponse)result);
                CertificateInfo.add(CertificateInfo.Type.VACCINATION, LocalDateTime.now(), documentId, ((SuccessResponse)result).uvci, patient);
                Result ret = Result.OK((String)((SuccessResponse)result).uvci);
                if (((SuccessResponse)result).appDeliveryError != null && ((SuccessResponse)result).appDeliveryError.errorMessage != null) {
                    ret.addMessage(Result.SEVERITY.OK, "App Transfer Fehler\n\n" + ((SuccessResponse)result).appDeliveryError.errorMessage);
                }
                return ret;
            }
            catch (ElexisException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error saving vaccination cert pdf", (Throwable)e);
                return new Result(Result.SEVERITY.ERROR, 0, e.getMessage(), (Object)e.getMessage(), false);
            }
        }
        return new Result(Result.SEVERITY.ERROR, 0, (String)result, (Object)((String)result), false);
    }

    public Result<String> createTestCertificate(IPatient patient, TestModel model) {
        Object result = this.covidCertificateApi.test(model);
        if (result instanceof SuccessResponse) {
            try {
                String documentId = this.pdfToOmnivore(patient, CertificateInfo.Type.TEST, (SuccessResponse)result);
                CertificateInfo.add(CertificateInfo.Type.TEST, LocalDateTime.now(), documentId, ((SuccessResponse)result).uvci, patient);
                Result ret = Result.OK((String)((SuccessResponse)result).uvci);
                if (((SuccessResponse)result).appDeliveryError != null && ((SuccessResponse)result).appDeliveryError.errorMessage != null) {
                    ret.addMessage(Result.SEVERITY.OK, "App Transfer Fehler\n\n" + ((SuccessResponse)result).appDeliveryError.errorMessage);
                }
                return ret;
            }
            catch (ElexisException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error saving test cert pdf", (Throwable)e);
                return new Result(Result.SEVERITY.ERROR, 0, e.getMessage(), (Object)e.getMessage(), false);
            }
        }
        return new Result(Result.SEVERITY.ERROR, 0, (String)result, (Object)((String)result), false);
    }

    public Result<String> createRecoveryCertificate(IPatient patient, RecoveryModel model) {
        Object result = this.covidCertificateApi.recovery(model);
        if (result instanceof SuccessResponse) {
            try {
                String documentId = this.pdfToOmnivore(patient, CertificateInfo.Type.RECOVERY, (SuccessResponse)result);
                CertificateInfo.add(CertificateInfo.Type.RECOVERY, LocalDateTime.now(), documentId, ((SuccessResponse)result).uvci, patient);
                Result ret = Result.OK((String)((SuccessResponse)result).uvci);
                if (((SuccessResponse)result).appDeliveryError != null && ((SuccessResponse)result).appDeliveryError.errorMessage != null) {
                    ret.addMessage(Result.SEVERITY.OK, "App Transfer Fehler\n\n" + ((SuccessResponse)result).appDeliveryError.errorMessage);
                }
                return ret;
            }
            catch (ElexisException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error saving recovery cert pdf", (Throwable)e);
                return new Result(Result.SEVERITY.ERROR, 0, e.getMessage(), (Object)e.getMessage(), false);
            }
        }
        return new Result(Result.SEVERITY.ERROR, 0, (String)result, (Object)((String)result), false);
    }

    public Result<String> revokeCertificate(IPatient patient, CertificateInfo info, RevokeModel model) {
        Object result = this.covidCertificateApi.revoke(model);
        if (result != null) {
            return new Result(Result.SEVERITY.ERROR, 0, (String)result, (Object)((String)result), false);
        }
        Optional document = this.omnivoreDocumentStore.loadDocument(info.getDocumentId());
        if (document.isPresent()) {
            this.omnivoreDocumentStore.removeDocument((IDocument)document.get());
        }
        CertificateInfo.remove(info, patient);
        return Result.OK();
    }

    private String pdfToOmnivore(IPatient patient, CertificateInfo.Type type, SuccessResponse result) throws ElexisException {
        ICategory category = this.omnivoreDocumentStore.createCategory("COVID Zertifikate");
        byte[] pdfBytes = DataValue.Base64.decode((String)result.pdf);
        IDocument document = this.omnivoreDocumentStore.createDocument(patient.getId(), "COVID " + type.getLabel() + " Zertifikat", category.getName());
        document.setMimeType("pdf");
        this.omnivoreDocumentStore.saveDocument(document, (InputStream)new ByteArrayInputStream(pdfBytes));
        return document.getId();
    }

    public Mode getMode() {
        String modeName = this.configService.get(CFG_MODE, "PROD");
        return Mode.valueOf(modeName);
    }

    public void setMode(Mode mode) {
        this.configService.set(CFG_MODE, mode.name());
        this.covidCertificateApi = new CovidCertificateApi(this.getMode(), this.keyProperties);
    }

    public String getOtpUrl() {
        if (this.getMode() == Mode.PROD) {
            return "https://www.covidcertificate.admin.ch/";
        }
        return "https://www.covidcertificate-a.admin.ch/";
    }

    public static enum Mode {
        PROD("https://ws.covidcertificate.bag.admin.ch"),
        TEST("https://ws.covidcertificate-a.bag.admin.ch");

        private String url;

        private Mode(String url) {
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

