/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.covid.cert.valueset;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.codes.IValueSetContribution;
import ch.elexis.covid.cert.valueset.JsonValueSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.LoggerFactory;

@Component
public class ChCovidValueSetsContribution
implements IValueSetContribution {
    private String[] names = new String[]{"country-alpha-2-de", "vaccine-medicinal-product", "test-type", "test-manufacturer"};
    private List<String> ids;
    private Map<String, JsonValueSet> idValueSetMap;
    private Map<String, JsonValueSet> nameValueSetMap;

    @Activate
    public void activate() {
        this.ids = new ArrayList<String>();
        this.idValueSetMap = new HashMap<String, JsonValueSet>();
        this.nameValueSetMap = new HashMap<String, JsonValueSet>();
        String[] stringArray = this.names;
        int n = this.names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Optional<JsonValueSet> valueSet = JsonValueSet.load(name);
            if (valueSet.isPresent()) {
                this.ids.add(valueSet.get().getId());
                this.idValueSetMap.put(valueSet.get().getId(), valueSet.get());
                this.nameValueSetMap.put(name, valueSet.get());
            } else {
                LoggerFactory.getLogger(this.getClass()).warn("Could not load valueset with name " + name);
            }
            ++n2;
        }
    }

    public List<String> getValueSetIds() {
        return this.ids;
    }

    public List<String> getValueSetNames() {
        return Arrays.asList(this.names);
    }

    public List<ICoding> getValueSet(String id) {
        if (this.idValueSetMap.get(id) != null) {
            return this.idValueSetMap.get(id).getCoding();
        }
        return Collections.emptyList();
    }

    public List<ICoding> getValueSetByName(String name) {
        if (this.nameValueSetMap.get(name) != null) {
            return this.nameValueSetMap.get(name).getCoding();
        }
        return Collections.emptyList();
    }
}

