/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.covid.cert.ui.dialogs;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.codes.IValueSetService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.covid.cert.service.rest.model.VaccinationModel;
import jakarta.inject.Inject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.LoggerFactory;

public class VaccinationModelDialog
extends Dialog {
    @Inject
    private IValueSetService valueSetService;
    private VaccinationModel model;
    private ComboViewer languageCombo;
    private ComboViewer productCombo;
    private Text dosage;
    private Text dosages;
    private CDateTime dateTime;
    private ComboViewer countryCombo;
    private Text transferCode;

    public VaccinationModelDialog(VaccinationModel model, Shell shell) {
        super(shell);
        this.model = model;
        CoreUiUtil.injectServices((Object)((Object)this));
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Daten der Impfung");
        parent = (Composite)super.createDialogArea(parent);
        this.languageCombo = new ComboViewer(parent, 2048);
        this.languageCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.languageCombo.setInput((Object)new String[]{"DE", "FR", "IT", "RM"});
        this.languageCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                VaccinationModelDialog.this.model.setLanguage(((String)event.getStructuredSelection().getFirstElement()).toLowerCase());
            }
        });
        this.languageCombo.setSelection((ISelection)new StructuredSelection((Object)this.model.getLanguage().toUpperCase()));
        this.languageCombo.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.languageCombo.getControl().setToolTipText("Sprache");
        this.productCombo = new ComboViewer(parent, 2048);
        this.productCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        List vaccinationValueSet = this.valueSetService.getValueSet("vaccines-covid-19-names");
        this.productCombo.setInput((Object)vaccinationValueSet);
        this.productCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ICoding) {
                    return ((ICoding)element).getDisplay();
                }
                return super.getText(element);
            }
        });
        this.productCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                VaccinationModelDialog.this.model.getVaccinationInfo()[0].setMedicinalProductCode(((ICoding)event.getStructuredSelection().getFirstElement()).getCode());
                if (VaccinationModelDialog.this.productCombo.getControl().getData("deco") != null) {
                    VaccinationModelDialog.this.removeErrorDecoration(VaccinationModelDialog.this.productCombo.getControl());
                }
            }
        });
        this.productCombo.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.productCombo.getControl().setToolTipText("Produkt");
        this.productCombo.getCombo().setText("Produkt");
        Composite dosageComp = new Composite(parent, 0);
        dosageComp.setLayout((Layout)new GridLayout(4, false));
        Label lbl = new Label(dosageComp, 0);
        lbl.setText("Impfung ");
        this.dosage = new Text(dosageComp, 2048);
        this.dosage.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (StringUtils.isNotBlank((CharSequence)VaccinationModelDialog.this.dosage.getText())) {
                    try {
                        VaccinationModelDialog.this.model.getVaccinationInfo()[0].setNumberOfDoses(Integer.parseInt(VaccinationModelDialog.this.dosage.getText()));
                        if (VaccinationModelDialog.this.dosage.getData("deco") != null) {
                            VaccinationModelDialog.this.removeErrorDecoration((Control)VaccinationModelDialog.this.dosage);
                        }
                    }
                    catch (NumberFormatException ex) {
                        VaccinationModelDialog.this.addErrorDecoration((Control)VaccinationModelDialog.this.dosage);
                    }
                }
            }
        });
        lbl = new Label(dosageComp, 0);
        lbl.setText(" von ");
        this.dosages = new Text(dosageComp, 2048);
        this.dosages.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (StringUtils.isNotBlank((CharSequence)VaccinationModelDialog.this.dosages.getText())) {
                    try {
                        VaccinationModelDialog.this.model.getVaccinationInfo()[0].setTotalNumberOfDoses(Integer.parseInt(VaccinationModelDialog.this.dosages.getText()));
                        if (VaccinationModelDialog.this.dosages.getData("deco") != null) {
                            VaccinationModelDialog.this.removeErrorDecoration((Control)VaccinationModelDialog.this.dosages);
                        }
                    }
                    catch (NumberFormatException ex) {
                        VaccinationModelDialog.this.addErrorDecoration((Control)VaccinationModelDialog.this.dosages);
                    }
                }
            }
        });
        this.dateTime = new CDateTime(parent, 2098179);
        this.dateTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Date now = new Date();
                if (VaccinationModelDialog.this.dateTime.getSelection() != null) {
                    Date selection = VaccinationModelDialog.this.dateTime.getSelection();
                    if (selection.before(now)) {
                        VaccinationModelDialog.this.model.getVaccinationInfo()[0].setVaccinationDate(new SimpleDateFormat("yyyy-MM-dd").format(selection));
                        VaccinationModelDialog.this.removeErrorDecoration((Control)VaccinationModelDialog.this.dateTime);
                    } else {
                        VaccinationModelDialog.this.addErrorDecoration((Control)VaccinationModelDialog.this.dateTime);
                    }
                }
            }
        });
        try {
            this.dateTime.setSelection(new SimpleDateFormat("yyyy-MM-dd").parse(this.model.getVaccinationInfo()[0].getVaccinationDate()));
        }
        catch (ParseException e1) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Could not parse date [" + this.model.getVaccinationInfo()[0].getVaccinationDate() + "]");
        }
        this.dateTime.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.dateTime.setToolTipText("Datum der Impfung");
        this.countryCombo = new ComboViewer(parent, 2048);
        this.countryCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.countryCombo.setInput(this.valueSetService.getValueSet("country-alpha-2-de").stream().map(c -> c.getCode()).collect(Collectors.toList()));
        this.countryCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                VaccinationModelDialog.this.model.getVaccinationInfo()[0].setCountryOfVaccination((String)event.getStructuredSelection().getFirstElement());
            }
        });
        this.countryCombo.setSelection((ISelection)new StructuredSelection((Object)this.model.getVaccinationInfo()[0].getCountryOfVaccination()));
        this.countryCombo.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.countryCombo.getControl().setToolTipText("Land der Impfung");
        String defaultVaccCode = ConfigServiceHolder.get().get("ch.elexis.covid.cert/default/vaccproductcode", null);
        if (defaultVaccCode != null) {
            vaccinationValueSet.stream().filter(c -> c.getCode().equals(defaultVaccCode)).findFirst().ifPresent(c -> this.productCombo.setSelection((ISelection)new StructuredSelection(c)));
        }
        this.transferCode = new Text(parent, 2048);
        this.transferCode.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.transferCode.setTextLimit(9);
        this.transferCode.setMessage("Transfer Code");
        this.transferCode.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (VaccinationModelDialog.this.transferCode.getText() != null) {
                    if (!VaccinationModelDialog.this.transferCode.getText().equals(VaccinationModelDialog.this.transferCode.getText().toUpperCase())) {
                        VaccinationModelDialog.this.transferCode.setText(VaccinationModelDialog.this.transferCode.getText().toUpperCase());
                        VaccinationModelDialog.this.transferCode.setSelection(VaccinationModelDialog.this.transferCode.getText().length());
                    }
                    if (VaccinationModelDialog.this.transferCode.getText().length() == 9) {
                        VaccinationModelDialog.this.model.setAppCode(VaccinationModelDialog.this.transferCode.getText());
                        return;
                    }
                }
                VaccinationModelDialog.this.model.setAppCode(null);
            }
        });
        this.dosage.setFocus();
        return parent;
    }

    protected void okPressed() {
        if (StringUtils.isEmpty((CharSequence)this.model.getVaccinationInfo()[0].getMedicinalProductCode())) {
            this.addErrorDecoration(this.productCombo.getControl());
            return;
        }
        if (this.model.getVaccinationInfo()[0].getNumberOfDoses() == null) {
            this.addErrorDecoration((Control)this.dosage);
            return;
        }
        if (this.model.getVaccinationInfo()[0].getTotalNumberOfDoses() == null) {
            this.addErrorDecoration((Control)this.dosages);
            return;
        }
        try {
            if (this.model.getVaccinationInfo()[0].getVaccinationDate() == null || new SimpleDateFormat("yyyy-MM-dd").parse(this.model.getVaccinationInfo()[0].getVaccinationDate()).after(new Date())) {
                this.addErrorDecoration((Control)this.dateTime);
                return;
            }
        }
        catch (ParseException e) {
            this.addErrorDecoration((Control)this.dateTime);
            return;
        }
        super.okPressed();
    }

    private void removeErrorDecoration(Control control) {
        if (control.getData("deco") != null) {
            ((ControlDecoration)control.getData("deco")).hide();
            ((ControlDecoration)control.getData("deco")).dispose();
            control.setData("deco", null);
        }
    }

    private void addErrorDecoration(Control control) {
        if (control.getData("deco") == null) {
            ControlDecoration deco = new ControlDecoration(control, 16512);
            deco.setDescriptionText("Fehlende oder fehlerhafte Eingabe");
            deco.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
            deco.setShowOnlyOnFocus(false);
            deco.show();
            control.setData("deco", (Object)deco);
        }
    }
}

