/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.covid.cert.service;

import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

public class CertificateInfo {
    private static String EXTINFO_KEY = "ch.elexis.covid.certinfo";
    private Type type;
    private LocalDateTime timestamp;
    private String documentId;
    private String uvci;

    public Type getType() {
        return this.type;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public String getUvci() {
        return this.uvci;
    }

    private static CertificateInfo of(String infoStringPart) {
        String[] parts = infoStringPart.split("\\|");
        if (parts.length == 4) {
            CertificateInfo ret = new CertificateInfo();
            ret.timestamp = LocalDateTime.parse(parts[0]);
            ret.type = Type.valueOf(parts[1]);
            ret.documentId = parts[2];
            ret.uvci = parts[3];
            return ret;
        }
        LoggerFactory.getLogger(CertificateInfo.class).error("No valid input [" + infoStringPart + "]");
        return null;
    }

    public static CertificateInfo add(Type type, LocalDateTime timestamp, String documentId, String uvci, IPatient patient) {
        List<CertificateInfo> certificates = CertificateInfo.of(patient);
        if (certificates == null || certificates.isEmpty()) {
            certificates = new ArrayList<CertificateInfo>();
        }
        CertificateInfo ret = new CertificateInfo();
        ret.timestamp = timestamp;
        ret.type = type;
        ret.documentId = documentId;
        ret.uvci = uvci;
        certificates.add(ret);
        StringJoiner sj = new StringJoiner("||");
        for (CertificateInfo certificateInfo : certificates) {
            sj.add(certificateInfo.toString());
        }
        patient.setExtInfo((Object)EXTINFO_KEY, (Object)sj.toString());
        CoreModelServiceHolder.get().save((Identifiable)patient);
        return ret;
    }

    public static void remove(CertificateInfo info, IPatient patient) {
        List<CertificateInfo> certificates = CertificateInfo.of(patient);
        certificates = certificates.stream().filter(c -> !c.getUvci().equals(info.getUvci())).collect(Collectors.toList());
        StringJoiner sj = new StringJoiner("||");
        for (CertificateInfo certificateInfo : certificates) {
            sj.add(certificateInfo.toString());
        }
        patient.setExtInfo((Object)EXTINFO_KEY, (Object)sj.toString());
        CoreModelServiceHolder.get().save((Identifiable)patient);
    }

    public static List<CertificateInfo> of(IPatient patient) {
        Object infoString = patient.getExtInfo((Object)EXTINFO_KEY);
        if (infoString instanceof String) {
            String[] infoStringParts;
            ArrayList<CertificateInfo> ret = new ArrayList<CertificateInfo>();
            String[] stringArray = infoStringParts = ((String)infoString).split("\\|\\|");
            int n = infoStringParts.length;
            int n2 = 0;
            while (n2 < n) {
                String infoStringPart = stringArray[n2];
                CertificateInfo info = CertificateInfo.of(infoStringPart);
                if (info != null) {
                    ret.add(CertificateInfo.of(infoStringPart));
                }
                ++n2;
            }
            ret.sort((l, r) -> l.getTimestamp().compareTo(r.getTimestamp()));
            return ret;
        }
        return Collections.emptyList();
    }

    public String toString() {
        return this.timestamp.toString() + "|" + this.type.name() + "|" + this.documentId + "|" + this.uvci;
    }

    public static enum Type {
        VACCINATION("Impfung"),
        RECOVERY("Genesen"),
        TEST("Test");

        private String label;

        private Type(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

