/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.covid.cert.service.rest;

import ch.elexis.covid.cert.service.CertificatesService;
import ch.elexis.covid.cert.service.rest.model.RecoveryModel;
import ch.elexis.covid.cert.service.rest.model.RevokeModel;
import ch.elexis.covid.cert.service.rest.model.SuccessResponse;
import ch.elexis.covid.cert.service.rest.model.TestModel;
import ch.elexis.covid.cert.service.rest.model.VaccinationModel;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.LoggerFactory;

public class CovidCertificateApi {
    private Client jaxrsClient;
    private XSignatureClientRequestFilter xSignatureClientRequestFilter;
    private CertificatesService.Mode mode;
    private Gson gson;
    private Properties keyProperties;

    public CovidCertificateApi(CertificatesService.Mode mode, Properties keyProperties) {
        this.mode = mode;
        this.keyProperties = keyProperties;
        this.jaxrsClient = this.createJaxrsClient();
        this.gson = new GsonBuilder().create();
    }

    public synchronized Object vaccination(VaccinationModel model) {
        WebTarget target = this.jaxrsClient.target(this.getBaseUrl()).path("/api/v1/covidcertificate/vaccination");
        LoggerFactory.getLogger(this.getClass()).info("API target [" + String.valueOf(target) + "]");
        this.xSignatureClientRequestFilter.setPayload(this.gson.toJson((Object)model));
        Response response = target.request().post(Entity.json((Object)this.gson.toJson((Object)model)));
        if (response.getStatus() >= 300) {
            String message = "[" + response.getStatus() + "]\n" + (String)response.readEntity(String.class);
            LoggerFactory.getLogger(this.getClass()).error(message);
            return message;
        }
        return response.readEntity(SuccessResponse.class);
    }

    public synchronized Object test(TestModel model) {
        WebTarget target = this.jaxrsClient.target(this.getBaseUrl()).path("/api/v1/covidcertificate/test");
        LoggerFactory.getLogger(this.getClass()).info("API target [" + String.valueOf(target) + "]");
        this.xSignatureClientRequestFilter.setPayload(this.gson.toJson((Object)model));
        Response response = target.request().post(Entity.json((Object)this.gson.toJson((Object)model)));
        if (response.getStatus() >= 300) {
            String message = "[" + response.getStatus() + "]\n" + (String)response.readEntity(String.class);
            LoggerFactory.getLogger(this.getClass()).error(message);
            return message;
        }
        return response.readEntity(SuccessResponse.class);
    }

    public synchronized Object recovery(RecoveryModel model) {
        WebTarget target = this.jaxrsClient.target(this.getBaseUrl()).path("/api/v1/covidcertificate/recovery");
        LoggerFactory.getLogger(this.getClass()).info("API target [" + String.valueOf(target) + "]");
        this.xSignatureClientRequestFilter.setPayload(this.gson.toJson((Object)model));
        Response response = target.request().post(Entity.json((Object)this.gson.toJson((Object)model)));
        if (response.getStatus() >= 300) {
            String message = "[" + response.getStatus() + "]\n" + (String)response.readEntity(String.class);
            LoggerFactory.getLogger(this.getClass()).error(message);
            return message;
        }
        return response.readEntity(SuccessResponse.class);
    }

    public synchronized Object revoke(RevokeModel model) {
        WebTarget target = this.jaxrsClient.target(this.getBaseUrl()).path("/api/v1/covidcertificate/revoke");
        LoggerFactory.getLogger(this.getClass()).info("API target [" + String.valueOf(target) + "]");
        this.xSignatureClientRequestFilter.setPayload(this.gson.toJson((Object)model));
        Response response = target.request().post(Entity.json((Object)this.gson.toJson((Object)model)));
        if (response.getStatus() >= 300) {
            String message = "[" + response.getStatus() + "]\n" + (String)response.readEntity(String.class);
            LoggerFactory.getLogger(this.getClass()).error(message);
            return message;
        }
        return null;
    }

    public synchronized Object issuableVaccines() {
        WebTarget target = this.jaxrsClient.target(this.getBaseUrl()).path("/api/v1/valuesets/issuable-vaccines");
        LoggerFactory.getLogger(this.getClass()).info("API target [" + String.valueOf(target) + "]");
        Response response = target.request().get();
        if (response.getStatus() >= 300) {
            String message = "[" + response.getStatus() + "]\n" + (String)response.readEntity(String.class);
            LoggerFactory.getLogger(this.getClass()).error(message);
            return message;
        }
        return response.readEntity(String.class);
    }

    public synchronized Object issuableRapidTests() {
        WebTarget target = this.jaxrsClient.target(this.getBaseUrl()).path("/api/v1/valuesets/issuable-rapid-tests");
        LoggerFactory.getLogger(this.getClass()).info("API target [" + String.valueOf(target) + "]");
        Response response = target.request().get();
        if (response.getStatus() >= 300) {
            String message = "[" + response.getStatus() + "]\n" + (String)response.readEntity(String.class);
            LoggerFactory.getLogger(this.getClass()).error(message);
            return message;
        }
        return response.readEntity(String.class);
    }

    private String getBaseUrl() {
        return this.mode.getUrl();
    }

    private Client createJaxrsClient() {
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            KeyStore clientStore = KeyStore.getInstance("PKCS12");
            clientStore.load(this.getClass().getClassLoader().getResourceAsStream("/rsc/" + this.keyProperties.getProperty(this.mode == CertificatesService.Mode.TEST ? "testcert" : "prodcert")), this.keyProperties.getProperty(this.mode == CertificatesService.Mode.TEST ? "testcertpass" : "prodcertpass").toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(clientStore, this.keyProperties.getProperty(this.mode == CertificatesService.Mode.TEST ? "testcertpass" : "prodcertpass").toCharArray());
            sslcontext.init(kmf.getKeyManagers(), new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, new SecureRandom());
            return ClientBuilder.newBuilder().sslContext(sslcontext).hostnameVerifier((s1, s2) -> true).withConfig(this.getClientConfig()).build();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).warn("Error creating jaxrs client", (Throwable)e);
            return null;
        }
    }

    private Configuration getClientConfig() {
        ClientConfig config = new ClientConfig();
        this.xSignatureClientRequestFilter = new XSignatureClientRequestFilter();
        config.register((Object)this.xSignatureClientRequestFilter);
        return config;
    }

    private class XSignatureClientRequestFilter
    implements ClientRequestFilter {
        private String payload;
        private String signedPayload;
        private PrivateKey privateKey;

        private XSignatureClientRequestFilter() {
        }

        public void filter(ClientRequestContext request) throws IOException {
            request.getHeaders().add((Object)"X-Signature", (Object)this.getSignedPayload());
        }

        public String getSignedPayload() {
            if (this.signedPayload == null) {
                this.signPayload();
            }
            return this.signedPayload;
        }

        private void signPayload() {
            if (this.payload != null) {
                PrivateKey privateKey = this.getPrivateKey();
                String normalizedJson = this.payload.replaceAll("[\\n\\r\\t ]", "");
                byte[] bytes = normalizedJson.getBytes(StandardCharsets.UTF_8);
                try {
                    try {
                        Signature signature = Signature.getInstance("SHA256withRSA");
                        signature.initSign(privateKey);
                        signature.update(bytes);
                        this.signedPayload = Base64.getEncoder().encodeToString(signature.sign());
                    }
                    catch (Exception e) {
                        LoggerFactory.getLogger(this.getClass()).warn("Error signing payload", (Throwable)e);
                        this.payload = null;
                    }
                }
                finally {
                    this.payload = null;
                }
            }
        }

        public void setPayload(String json) {
            this.payload = json;
            this.signedPayload = null;
        }

        private PrivateKey getPrivateKey() {
            if (this.privateKey == null) {
                this.privateKey = this.loadPrivateKey();
            }
            return this.privateKey;
        }

        private PrivateKey loadPrivateKey() {
            PrivateKey privateKey = null;
            try {
                InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("/rsc/" + CovidCertificateApi.this.keyProperties.getProperty(CovidCertificateApi.this.mode == CertificatesService.Mode.TEST ? "testkey" : "prodkey"));
                if (inputStream != null) {
                    String pemString = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
                    pemString = pemString.replaceAll("(\\r|\\n|\\r\\n)+", "");
                    String keyString = StringUtils.substringBetween((String)pemString, (String)"-----BEGIN PRIVATE KEY-----", (String)"-----END PRIVATE KEY-----");
                    byte[] decoded = Base64.getDecoder().decode(keyString);
                    KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                    PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(decoded);
                    return keyFactory.generatePrivate(keySpec);
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).warn("Error loading private key", (Throwable)e);
            }
            return privateKey;
        }
    }
}

