/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.covid.cert.ui.handler;

import ch.elexis.core.model.ICodeElementBlock;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.builder.IEncounterBuilder;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.CoverageServiceHolder;
import ch.elexis.covid.cert.ui.handler.CovidHandlerUtil;
import jakarta.inject.Inject;
import java.time.LocalDate;
import java.util.Map;
import java.util.Optional;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CovidPcrKk {
    @Inject
    private IContextService contextService;

    @Execute
    public void execute() {
        Optional activePatient = this.contextService.getActivePatient();
        activePatient.ifPresent(patient -> {
            Map<String, ICodeElementBlock> blocks = CovidHandlerUtil.getConfiguredBlocks();
            if (!blocks.isEmpty()) {
                Optional kkCoverage = CoverageServiceHolder.get().getCoverageWithLaw(patient, CovidHandlerUtil.KK_LAWS);
                Optional<IEncounter> pcrEncounter = CovidHandlerUtil.getEncountersAt(patient, LocalDate.now(), null).stream().filter(e -> CovidHandlerUtil.isPcrBilled(e)).findFirst();
                if (kkCoverage.isPresent()) {
                    if (pcrEncounter.isEmpty()) {
                        this.bill((ICoverage)kkCoverage.get());
                        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Verrechnet", (String)"Es wurde ein Krankenkassen PCR Test verrechnet.");
                    } else {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Bereits verrechnet", (String)"Es wurde bereits ein PCR Test heute verrechnet.");
                    }
                } else {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Kein Fall", (String)"Es wurde noch kein Fall mit Gesetz KVG angelegt.");
                }
            }
        });
    }

    private void bill(ICoverage coverage) {
        ICodeElementBlock kkBlock = CovidHandlerUtil.getConfiguredBlocks().get("ch.elexis.covid.cert.ui/kk_pcr_blockid");
        if (kkBlock != null) {
            IEncounter encounter = (IEncounter)new IEncounterBuilder(CoreModelServiceHolder.get(), coverage, (IMandator)this.contextService.getActiveMandator().get()).buildAndSave();
            CovidHandlerUtil.addBlockToEncounter(kkBlock, encounter);
            this.contextService.getRootContext().setTyped((Object)encounter);
        } else {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Kein Krankenkassen PCR Block konfiguriert.");
        }
    }
}

