/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.covid.cert.ui.dialogs;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.codes.IValueSetService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.covid.cert.service.rest.model.TestInfo;
import ch.elexis.covid.cert.service.rest.model.TestModel;
import jakarta.inject.Inject;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.LoggerFactory;

public class TestModelDialog
extends Dialog {
    @Inject
    private IValueSetService valueSetService;
    private TestModel model;
    private ComboViewer typeCombo;
    private ComboViewer manufacturerCombo;
    private CDateTime sampleDateTime;
    private Text testingCenter;
    private ComboViewer countryCombo;
    private Text transferCode;

    public TestModelDialog(TestModel model, Shell shell) {
        super(shell);
        this.model = model;
        CoreUiUtil.injectServices((Object)((Object)this));
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Daten des Test");
        parent = (Composite)super.createDialogArea(parent);
        this.typeCombo = new ComboViewer(parent, 2048);
        this.typeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.typeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ICoding) {
                    return ((ICoding)element).getDisplay();
                }
                return super.getText(element);
            }
        });
        List testsTypeValueSet = this.valueSetService.getValueSet("covid-19-test-type");
        this.typeCombo.setInput((Object)testsTypeValueSet);
        this.typeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                String code = ((ICoding)TestModelDialog.this.typeCombo.getStructuredSelection().getFirstElement()).getCode();
                TestModelDialog.this.model.getTestInfo()[0].setTypeCode(code);
                if (TestModelDialog.this.typeCombo.getControl().getData("deco") != null) {
                    TestModelDialog.this.removeErrorDecoration(TestModelDialog.this.typeCombo.getControl());
                }
                if ("LP6464-4".equals(code)) {
                    TestModelDialog.this.manufacturerCombo.getControl().setEnabled(false);
                    TestModelDialog.this.model.getTestInfo()[0].setManufacturerCode(null);
                } else {
                    TestModelDialog.this.model.getTestInfo()[0].setManufacturerCode(null);
                    TestModelDialog.this.manufacturerCombo.setSelection((ISelection)new StructuredSelection());
                    TestModelDialog.this.manufacturerCombo.getControl().setEnabled(true);
                }
            }
        });
        this.typeCombo.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.typeCombo.getControl().setToolTipText("Test Typ");
        this.typeCombo.getCombo().setText("Test Typ");
        this.manufacturerCombo = new ComboViewer(parent, 2048);
        this.manufacturerCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        List testsValueSet = this.valueSetService.getValueSet("covid-19-lab-test-manufacturer");
        this.manufacturerCombo.setInput((Object)testsValueSet);
        this.manufacturerCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ICoding) {
                    return ((ICoding)element).getDisplay();
                }
                return super.getText(element);
            }
        });
        this.manufacturerCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getStructuredSelection() != null && event.getStructuredSelection().getFirstElement() != null) {
                    TestModelDialog.this.model.getTestInfo()[0].setManufacturerCode(((ICoding)event.getStructuredSelection().getFirstElement()).getCode());
                    if (TestModelDialog.this.manufacturerCombo.getControl().getData("deco") != null) {
                        TestModelDialog.this.removeErrorDecoration(TestModelDialog.this.manufacturerCombo.getControl());
                    }
                }
            }
        });
        this.manufacturerCombo.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.manufacturerCombo.getControl().setToolTipText("Produkt");
        this.manufacturerCombo.getCombo().setText("Produkt");
        this.sampleDateTime = new CDateTime(parent, 0xA00003);
        this.sampleDateTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Date now = new Date();
                if (TestModelDialog.this.sampleDateTime.getSelection() != null) {
                    Date selection = TestModelDialog.this.sampleDateTime.getSelection();
                    if (selection.before(now)) {
                        ZonedDateTime zonedSelected = ZonedDateTime.ofInstant(selection.toInstant(), ZoneId.systemDefault());
                        ZonedDateTime utcDateTime = zonedSelected.withZoneSameInstant(ZoneId.of("Z"));
                        TestModelDialog.this.model.getTestInfo()[0].setSampleDateTime(TestInfo.formatter.format(utcDateTime));
                        TestModelDialog.this.removeErrorDecoration((Control)TestModelDialog.this.sampleDateTime);
                    } else {
                        TestModelDialog.this.addErrorDecoration((Control)TestModelDialog.this.sampleDateTime);
                    }
                }
            }
        });
        try {
            ZonedDateTime utcDateTime = LocalDateTime.parse(this.model.getTestInfo()[0].getSampleDateTime(), TestInfo.formatter).atZone(ZoneId.of("Z"));
            ZonedDateTime localDateTime = utcDateTime.withZoneSameInstant(ZoneId.systemDefault());
            this.sampleDateTime.setSelection(Date.from(localDateTime.toInstant()));
        }
        catch (DateTimeParseException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Could not parse date [" + this.model.getTestInfo()[0].getSampleDateTime() + "]");
        }
        this.sampleDateTime.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.sampleDateTime.setToolTipText("Datum der Probe");
        this.testingCenter = new Text(parent, 2048);
        this.testingCenter.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.testingCenter.setMessage("Test Ort Name (z.B. Praxis Name) max. 50 Zeichen");
        this.testingCenter.setToolTipText("Test Ort Name (z.B. Praxis Name) max. 50 Zeichen");
        this.testingCenter.setText(this.model.getTestInfo()[0].getTestingCentreOrFacility());
        this.testingCenter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (StringUtils.isNotBlank((CharSequence)TestModelDialog.this.testingCenter.getText())) {
                    TestModelDialog.this.model.getTestInfo()[0].setTestingCentreOrFacility(TestModelDialog.this.testingCenter.getText());
                    if (TestModelDialog.this.testingCenter.getData("deco") != null) {
                        TestModelDialog.this.removeErrorDecoration((Control)TestModelDialog.this.testingCenter);
                    }
                }
            }
        });
        this.countryCombo = new ComboViewer(parent, 2048);
        this.countryCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.countryCombo.setInput(this.valueSetService.getValueSet("country-alpha-2-de").stream().map(c -> c.getCode()).collect(Collectors.toList()));
        this.countryCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TestModelDialog.this.model.getTestInfo()[0].setMemberStateOfTest((String)event.getStructuredSelection().getFirstElement());
            }
        });
        this.countryCombo.setSelection((ISelection)new StructuredSelection((Object)this.model.getTestInfo()[0].getMemberStateOfTest()));
        this.countryCombo.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.countryCombo.getControl().setToolTipText("Land des Test");
        if (StringUtils.isBlank((CharSequence)this.model.getTestInfo()[0].getTypeCode())) {
            this.initDefaultAntigen(testsTypeValueSet, testsValueSet);
        } else {
            ((GridData)this.typeCombo.getCombo().getLayoutData()).exclude = true;
            this.typeCombo.getCombo().setVisible(false);
            this.typeCombo.getCombo().getParent().layout();
            if ("LP6464-4".equals(this.model.getTestInfo()[0].getTypeCode())) {
                this.manufacturerCombo.getControl().setEnabled(false);
                this.model.getTestInfo()[0].setManufacturerCode(null);
                this.initDefaultPcr(testsTypeValueSet, testsValueSet);
            } else {
                this.model.getTestInfo()[0].setManufacturerCode(null);
                this.manufacturerCombo.setSelection((ISelection)new StructuredSelection());
                this.manufacturerCombo.getControl().setEnabled(true);
                this.initDefaultAntigen(testsTypeValueSet, testsValueSet);
            }
        }
        this.transferCode = new Text(parent, 2048);
        this.transferCode.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.transferCode.setTextLimit(9);
        this.transferCode.setMessage("Transfer Code");
        this.transferCode.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TestModelDialog.this.transferCode.getText() != null) {
                    if (!TestModelDialog.this.transferCode.getText().equals(TestModelDialog.this.transferCode.getText().toUpperCase())) {
                        TestModelDialog.this.transferCode.setText(TestModelDialog.this.transferCode.getText().toUpperCase());
                        TestModelDialog.this.transferCode.setSelection(TestModelDialog.this.transferCode.getText().length());
                    }
                    if (TestModelDialog.this.transferCode.getText().length() == 9) {
                        TestModelDialog.this.model.setAppCode(TestModelDialog.this.transferCode.getText());
                        return;
                    }
                }
                TestModelDialog.this.model.setAppCode(null);
            }
        });
        this.manufacturerCombo.getControl().setFocus();
        return parent;
    }

    private void initDefaultPcr(List<ICoding> testsTypeValueSet, List<ICoding> testsValueSet) {
        testsTypeValueSet.stream().filter(c -> c.getCode().equals("LP6464-4")).findFirst().ifPresent(c -> this.typeCombo.setSelection((ISelection)new StructuredSelection(c)));
    }

    private void initDefaultAntigen(List<ICoding> testsTypeValueSet, List<ICoding> testsValueSet) {
        testsTypeValueSet.stream().filter(c -> c.getCode().equals("LP217198-3")).findFirst().ifPresent(c -> this.typeCombo.setSelection((ISelection)new StructuredSelection(c)));
        String defaultTestCode = ConfigServiceHolder.get().get("ch.elexis.covid.cert/default/testproductcode", null);
        if (defaultTestCode != null) {
            testsValueSet.stream().filter(c -> c.getCode().equals(defaultTestCode)).findFirst().ifPresent(c -> this.manufacturerCombo.setSelection((ISelection)new StructuredSelection(c)));
        }
    }

    protected void okPressed() {
        if (StringUtils.isEmpty((CharSequence)this.model.getTestInfo()[0].getTypeCode())) {
            this.addErrorDecoration(this.typeCombo.getControl());
            return;
        }
        try {
            if (this.model.getTestInfo()[0].getSampleDateTime() == null || LocalDateTime.parse(this.model.getTestInfo()[0].getSampleDateTime(), TestInfo.formatter).isAfter(LocalDateTime.now())) {
                this.addErrorDecoration((Control)this.sampleDateTime);
                return;
            }
        }
        catch (DateTimeParseException e) {
            this.addErrorDecoration((Control)this.sampleDateTime);
            return;
        }
        super.okPressed();
    }

    private void removeErrorDecoration(Control control) {
        if (control.getData("deco") != null) {
            ((ControlDecoration)control.getData("deco")).hide();
            ((ControlDecoration)control.getData("deco")).dispose();
            control.setData("deco", null);
        }
    }

    private void addErrorDecoration(Control control) {
        if (control.getData("deco") == null) {
            ControlDecoration deco = new ControlDecoration(control, 16512);
            deco.setDescriptionText("Fehlende oder fehlerhafte Eingabe");
            deco.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
            deco.setShowOnlyOnFocus(false);
            deco.show();
            control.setData("deco", (Object)deco);
        }
    }
}

