/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.connect.sysmex.packages;

import ch.elexis.connect.sysmex.packages.IProbe;
import ch.elexis.connect.sysmex.packages.PackageException;
import ch.elexis.connect.sysmex.packages.Value;
import ch.elexis.data.Patient;
import ch.rgw.tools.TimeTool;
import java.text.DecimalFormat;

public abstract class AbstractHaematologyData
implements IProbe {
    private TimeTool date;
    private String patId;
    private String wbc;
    private String rbc;
    private String hgb;
    private String hct;
    private String mcv;
    private String mch;
    private String mchc;
    private String plt;
    private String lym_percent;
    private String mxd_percent;
    private String neut_percent;
    private String lym_volume;
    private String mxd_volume;
    private String neut_volume;
    private String rdw_sd;
    private String rdw_cv;
    private String pdw;
    private String mpv;
    private String p_lcr;

    @Override
    public void parse(String content) {
        this.date = this.getDate(content);
        this.patId = this.getPatientId(content);
        this.wbc = this.getWBC(content);
        this.rbc = this.getRBC(content);
        this.hgb = this.getHGB(content);
        this.hct = this.getHCT(content);
        this.mcv = this.getMCV(content);
        this.mch = this.getMCH(content);
        this.mchc = this.getMCHC(content);
        this.plt = this.getPLT(content);
        this.lym_percent = this.getLYMPercent(content);
        this.mxd_percent = this.getMXDPercent(content);
        this.neut_percent = this.getNEUTPercent(content);
        this.lym_volume = this.getLYMVolume(content);
        this.mxd_volume = this.getMXDVolume(content);
        this.neut_volume = this.getNEUTVolume(content);
        this.rdw_sd = this.getRDWSD(content);
        this.rdw_cv = this.getRDWCV(content);
        this.pdw = this.getPDW(content);
        this.mpv = this.getMPV(content);
        this.p_lcr = this.getPLCR(content);
    }

    @Override
    public void write(Patient patient) throws PackageException {
        Value wbcVal = this.getValue("WBC");
        wbcVal.fetchValue(patient, this.wbc, -1, this.getDate());
        Value rbcVal = this.getValue("RBC");
        rbcVal.fetchValue(patient, this.rbc, -1, this.getDate());
        Value hgbVal = this.getValue("HGB");
        hgbVal.fetchValue(patient, this.hgb, -1, this.getDate());
        Value hctVal = this.getValue("HCT");
        hctVal.fetchValue(patient, this.hct, -1, this.getDate());
        Value mcvVal = this.getValue("MCV");
        mcvVal.fetchValue(patient, this.mcv, -1, this.getDate());
        Value mchVal = this.getValue("MCH");
        mchVal.fetchValue(patient, this.mch, -1, this.getDate());
        Value mchcVal = this.getValue("MCHC");
        mchcVal.fetchValue(patient, this.mchc, -1, this.getDate());
        Value pltVal = this.getValue("PLT");
        pltVal.fetchValue(patient, this.plt, -1, this.getDate());
        Value lymPercentVal = this.getValue("LYM%");
        lymPercentVal.fetchValue(patient, this.lym_percent, -1, this.getDate());
        Value mxdPercentVal = this.getValue("MXD%");
        mxdPercentVal.fetchValue(patient, this.mxd_percent, -1, this.getDate());
        Value neutPercentVal = this.getValue("NEUT%");
        neutPercentVal.fetchValue(patient, this.neut_percent, -1, this.getDate());
        Value lymVolumeVal = this.getValue("LYM#");
        lymVolumeVal.fetchValue(patient, this.lym_volume, -1, this.getDate());
        Value mxdVolumeVal = this.getValue("MXD#");
        mxdVolumeVal.fetchValue(patient, this.mxd_volume, -1, this.getDate());
        Value neutVolumeVal = this.getValue("NEUT#");
        neutVolumeVal.fetchValue(patient, this.neut_volume, -1, this.getDate());
        if (this.rdw_sd != null) {
            Value rdwSdVal = this.getValue("RDW-SD");
            rdwSdVal.fetchValue(patient, this.rdw_sd, -1, this.getDate());
        }
        if (this.rdw_cv != null) {
            Value rdwCvVal = this.getValue("RDW-CV");
            rdwCvVal.fetchValue(patient, this.rdw_cv, -1, this.getDate());
        }
        Value pdwVal = this.getValue("PDW");
        pdwVal.fetchValue(patient, this.pdw, -1, this.getDate());
        Value mpvVal = this.getValue("MPV");
        mpvVal.fetchValue(patient, this.mpv, -1, this.getDate());
        Value pLcrVal = this.getValue("P-LCR");
        pLcrVal.fetchValue(patient, this.p_lcr, -1, this.getDate());
    }

    public TimeTool getDate() {
        return this.date;
    }

    @Override
    public String getPatientId() {
        return this.patId;
    }

    protected String getValueStr(String content, int pos, String pattern) {
        int l1 = 0;
        int l2 = 0;
        String[] parts = pattern.split("\\.");
        Object decimalPattern = parts[0].replace('X', '#').replace('F', ' ').trim();
        decimalPattern = ((String)decimalPattern).substring(0, ((String)decimalPattern).length() - 1) + "0";
        l1 = ((String)decimalPattern).length();
        if (parts.length > 1) {
            decimalPattern = (String)decimalPattern + "." + parts[1].replace('X', '0').replace('F', ' ').trim();
            l2 = ((String)decimalPattern).length() - l1 - 1;
        }
        Object strValue = content.substring(pos, pos + l1);
        if (l2 > 0) {
            strValue = (String)strValue + "." + content.substring(pos + l1, pos + l1 + l2);
        }
        double value = 0.0;
        try {
            value = Double.parseDouble((String)strValue);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        DecimalFormat nf = new DecimalFormat((String)decimalPattern);
        return nf.format(value);
    }

    protected String getWBC(String content) {
        int pos = this.getDataIndex();
        return this.getValueStr(content, pos, "XXX.XF");
    }

    protected String getRBC(String content) {
        int pos = this.getDataIndex() + 5;
        return this.getValueStr(content, pos, "XX.XXF");
    }

    protected String getHGB(String content) {
        int pos = this.getDataIndex() + 10;
        return this.getValueStr(content, pos, "XXX.XF");
    }

    protected String getHCT(String content) {
        int pos = this.getDataIndex() + 15;
        return this.getValueStr(content, pos, "XXX.XF");
    }

    protected String getMCV(String content) {
        int pos = this.getDataIndex() + 20;
        return this.getValueStr(content, pos, "XXX.XF");
    }

    protected String getMCH(String content) {
        int pos = this.getDataIndex() + 25;
        return this.getValueStr(content, pos, "XXX.XF");
    }

    protected String getMCHC(String content) {
        int pos = this.getDataIndex() + 30;
        return this.getValueStr(content, pos, "XXX.XF");
    }

    protected String getPLT(String content) {
        int pos = this.getDataIndex() + 35;
        return this.getValueStr(content, pos, "XXXXF");
    }

    protected String getLYMPercent(String content) {
        int pos = this.getDataIndex() + 40;
        return this.getValueStr(content, pos, "XXX.XF");
    }

    protected String getMXDPercent(String content) {
        int pos = this.getDataIndex() + 45;
        return this.getValueStr(content, pos, "XXX.XF");
    }

    protected String getNEUTPercent(String content) {
        int pos = this.getDataIndex() + 50;
        return this.getValueStr(content, pos, "XXX.XF");
    }

    protected String getLYMVolume(String content) {
        int pos = this.getDataIndex() + 55;
        return this.getValueStr(content, pos, "XXX.XF");
    }

    protected String getMXDVolume(String content) {
        int pos = this.getDataIndex() + 60;
        return this.getValueStr(content, pos, "XXX.XF");
    }

    protected String getNEUTVolume(String content) {
        int pos = this.getDataIndex() + 65;
        return this.getValueStr(content, pos, "XXX.XF");
    }

    protected abstract String getRDWSD(String var1);

    protected abstract String getRDWCV(String var1);

    protected abstract String getPDW(String var1);

    protected abstract String getMPV(String var1);

    protected abstract String getPLCR(String var1);

    @Override
    public abstract int getSize();

    protected abstract int getDataIndex();

    protected abstract TimeTool getDate(String var1);

    protected abstract Value getValue(String var1) throws PackageException;

    protected abstract String getPatientId(String var1);
}

