/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.connect.reflotron.packages;

import ch.elexis.connect.reflotron.Messages;
import ch.elexis.connect.reflotron.packages.PackageException;
import ch.elexis.connect.reflotron.packages.Value;
import ch.elexis.core.importer.div.importers.ImportHandler;
import ch.elexis.core.importer.div.importers.TransientLabResult;
import ch.elexis.core.importer.div.service.holder.LabImportUtilHolder;
import ch.elexis.core.ui.importer.div.importers.DefaultLabImportUiHandler;
import ch.elexis.data.Patient;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.Collections;

public class Probe {
    private static final String UNIT_TEST_RUNNING = "ElexisReflotronUnitTestRunning";
    private static int NAME = 0;
    private static int VALUE = 1;
    private static int UNIT = 2;
    private boolean isEnzym;
    private TimeTool date;
    private String ident;
    private String resultat;
    private String hint;
    private String zusatztext;

    public Probe(String[] strArray) {
        this.parse(strArray);
    }

    private void parse(String[] strArray) {
        int dateIndex = strArray[1].indexOf(".");
        int timeIndex = strArray[1].indexOf(":");
        String dateStr = strArray[1].substring(dateIndex - 2, dateIndex + 6);
        String timeStr = strArray[1].substring(timeIndex - 2, timeIndex + 6);
        this.date = new TimeTool(dateStr);
        this.date.set(timeStr);
        if (strArray.length > 2) {
            this.ident = strArray[2].trim();
        }
        if (strArray.length > 3) {
            this.resultat = strArray[3];
        }
        if (strArray.length > 4) {
            this.hint = strArray[4].trim();
        }
        if (strArray.length > 5) {
            this.zusatztext = strArray[5].trim();
        }
    }

    public String write(Patient patient) throws PackageException {
        String value;
        if (this.resultat == null || this.resultat.isEmpty()) {
            throw new PackageException(Messages.Reflotron_Probe_ResultatMsg);
        }
        this.isEnzym = false;
        String[] resFields = this.splitResultFields();
        int noFields = resFields.length;
        int offset = 0;
        String paramName = resFields[NAME];
        if (!this.isEnzym && noFields == 4 || this.isEnzym && noFields == 5) {
            offset = 1;
            value = (resFields[VALUE] + resFields[VALUE + offset]).trim();
        } else {
            value = resFields[VALUE];
        }
        String unit = resFields[UNIT + offset];
        Value val = Value.getValue(paramName, unit);
        if (UNIT_TEST_RUNNING.equals(this.hint)) {
            return val.get_longName() + ";" + val.get_shortName() + ";" + value + ";" + unit;
        }
        TransientLabResult result = val.fetchValue(patient, value, "", this.getDate());
        LabImportUtilHolder.get().importLabResults(Collections.singletonList(result), (ImportHandler)new DefaultLabImportUiHandler());
        return val.getWarning();
    }

    private String[] splitResultFields() throws PackageException {
        String prevChar;
        boolean matches;
        this.resultat = this.resultat.replaceAll("\\s+", " ").trim();
        String[] split = this.resultat.split(" ");
        String regex = "^[a-zA-Z0-9/]+$";
        if (this.resultat.endsWith("C") && !(matches = (prevChar = this.resultat.substring(this.resultat.length() - 2, this.resultat.length() - 1)).matches(regex))) {
            this.isEnzym = true;
            if (split.length < 4 && this.resultat.length() > 20) {
                ArrayList<String> splitList = new ArrayList<String>();
                splitList.add(this.resultat.substring(0, 4).trim().toUpperCase());
                splitList.add(this.resultat.substring(4, 10).trim());
                splitList.add(this.resultat.substring(10, 16).trim());
                splitList.add(this.resultat.substring(16, 20).trim());
                return splitList.toArray(new String[splitList.size()]);
            }
        }
        if (split.length < 3) {
            throw new PackageException(Messages.Reflotron_Probe_ResultatMsg);
        }
        return split;
    }

    public TimeTool getDate() {
        return this.date;
    }

    public String getIdent() {
        return this.ident;
    }

    public String getResultat() {
        return this.resultat;
    }

    public String getHint() {
        return this.hint;
    }

    public String getZusatztext() {
        return this.zusatztext;
    }

    public void setResult(String resultat) {
        this.resultat = resultat;
    }
}

