/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.connect.fuji.drichem3500;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.importer.div.rs232.Connection;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import ch.elexis.core.ui.util.SWTHelper;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class Preferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String FUJI_BASE = "connectors/fuji-drichem-3500/";
    public static final String PORT = "connectors/fuji-drichem-3500/port";
    public static final String PARAMS = "connectors/fuji-drichem-3500/params";
    public static final String ETHERNET_PORT = "connectors/fuji-drichem-3500/ethernetport";
    public static final String SELECTED_CONNECTION = "connectors/fuji-drichem-3500/connection";
    private Combo comPorts;
    private Text speed;
    private Combo dataBits;
    private Combo parity;
    private Combo stopBits;
    private Combo connectionType;
    private Text ethernetPort;
    private Combo flowControlIn;
    private Combo flowControlOut;

    public Preferences() {
        super("Fuji DriChem");
        this.setPreferenceStore((IPreferenceStore)new SettingsPreferenceStore(CoreHub.localCfg));
    }

    protected Control createContents(Composite parent) {
        String[] param = CoreHub.localCfg.get(PARAMS, "9600,8,n,1,0,0").split(",");
        final String[] connection = new String[]{"Ethernet", "Seriell"};
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout(3, false));
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        Label lblConnection = new Label(ret, 0);
        lblConnection.setText("Schnittstelle w\u00e4hlen");
        this.connectionType = new Combo(ret, 4);
        GridData gd_connectionType = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_connectionType.widthHint = 50;
        this.connectionType.setLayoutData((Object)gd_connectionType);
        this.connectionType.add(connection[0]);
        this.connectionType.add(connection[1]);
        this.connectionType.setText(param[1]);
        this.connectionType.setText(CoreHub.localCfg.get(SELECTED_CONNECTION, "Seriell"));
        this.connectionType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Preferences.this.connectionType.getText().equals(connection[0])) {
                    Preferences.this.setEthernet(true);
                } else {
                    Preferences.this.setEthernet(false);
                }
            }
        });
        new Label(ret, 0);
        new Label(ret, 0);
        new Label(ret, 0);
        new Label(ret, 0);
        Label lblEthernetPort = new Label(ret, 0);
        lblEthernetPort.setText("Ethernet Port");
        this.ethernetPort = new Text(ret, 2048);
        GridData gd_ePort = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_ePort.widthHint = 65;
        this.ethernetPort.setLayoutData((Object)gd_ePort);
        this.ethernetPort.setText(CoreHub.localCfg.get(ETHERNET_PORT, "5000"));
        new Label(ret, 0);
        new Label(ret, 0);
        new Label(ret, 0);
        new Label(ret, 0);
        Label lblComPort = new Label(ret, 0);
        lblComPort.setText("Com-Port");
        this.comPorts = new Combo(ret, 4);
        GridData gd_comPorts = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_comPorts.widthHint = 50;
        this.comPorts.setLayoutData((Object)gd_comPorts);
        this.comPorts.setItems(Connection.getComPorts());
        this.comPorts.setText(CoreHub.localCfg.get(PORT, "COM1"));
        new Label(ret, 0);
        Label lblSpeed = new Label(ret, 0);
        lblSpeed.setText("Geschwindigkeit");
        this.speed = new Text(ret, 2048);
        GridData gd_speed = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_speed.widthHint = 65;
        this.speed.setLayoutData((Object)gd_speed);
        this.speed.setText(param[0]);
        new Label(ret, 0);
        Label lblDatenBits = new Label(ret, 0);
        lblDatenBits.setText("Daten-Bits");
        this.dataBits = new Combo(ret, 4);
        GridData gd_dataBits = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_dataBits.widthHint = 50;
        this.dataBits.setLayoutData((Object)gd_dataBits);
        this.dataBits.add("5");
        this.dataBits.add("6");
        this.dataBits.add("7");
        this.dataBits.add("8");
        this.dataBits.setText(param[1]);
        new Label(ret, 0);
        Label lblParity = new Label(ret, 0);
        lblParity.setText("Parit\u00e4t");
        this.parity = new Combo(ret, 4);
        GridData gd_parity = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_parity.widthHint = 50;
        this.parity.setLayoutData((Object)gd_parity);
        this.parity.add("None");
        this.parity.add("Even");
        this.parity.add("Odd");
        this.parity.setText(param[2]);
        new Label(ret, 0);
        Label lblStopbit = new Label(ret, 0);
        lblStopbit.setText("Stop-Bit");
        this.stopBits = new Combo(ret, 4);
        GridData gd_stopBits = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_stopBits.widthHint = 50;
        this.stopBits.setLayoutData((Object)gd_stopBits);
        this.stopBits.add("1");
        this.stopBits.add("2");
        this.stopBits.setText(param[3]);
        new Label(ret, 0);
        String[] FC = new String[]{"NONE", "RTSCTS", "XONXOFF"};
        Label lblFlowcontrol = new Label(ret, 0);
        lblFlowcontrol.setText("Flowcontrol In");
        this.flowControlIn = new Combo(ret, 4);
        this.flowControlIn.setItems(FC);
        if (param.length > 4) {
            int paramFC = Integer.parseInt(param[4]);
            if (paramFC == 0) {
                this.flowControlIn.select(0);
            }
            if (paramFC == 1) {
                this.flowControlIn.select(1);
            }
            if (paramFC == 4) {
                this.flowControlIn.select(2);
            }
        }
        new Label(ret, 0);
        Label label = new Label(ret, 0);
        label.setText("Flowcontrol Out");
        this.flowControlOut = new Combo(ret, 4);
        this.flowControlOut.setItems(FC);
        if (param.length > 5) {
            int paramFCO = Integer.parseInt(param[5]);
            if (paramFCO == 0) {
                this.flowControlOut.select(0);
            }
            if (paramFCO == 2) {
                this.flowControlOut.select(1);
            }
            if (paramFCO == 8) {
                this.flowControlOut.select(2);
            }
        }
        new Label(ret, 0);
        this.setEthernet(this.connectionType.getText().equals(connection[0]));
        return ret;
    }

    public void init(IWorkbench workbench) {
    }

    protected void setEthernet(boolean b) {
        if (b) {
            this.ethernetPort.setEnabled(true);
            this.comPorts.setEnabled(false);
            this.speed.setEnabled(false);
            this.dataBits.setEnabled(false);
            this.parity.setEnabled(false);
            this.stopBits.setEnabled(false);
            this.flowControlIn.setEnabled(false);
            this.flowControlOut.setEnabled(false);
        } else {
            this.ethernetPort.setEnabled(false);
            this.comPorts.setEnabled(true);
            this.speed.setEnabled(true);
            this.dataBits.setEnabled(true);
            this.parity.setEnabled(true);
            this.stopBits.setEnabled(true);
            this.flowControlIn.setEnabled(true);
            this.flowControlOut.setEnabled(true);
        }
    }

    public boolean performOk() {
        CoreHub.localCfg.set(ETHERNET_PORT, this.ethernetPort.getText());
        CoreHub.localCfg.set(SELECTED_CONNECTION, this.connectionType.getText());
        StringBuilder sb = new StringBuilder();
        sb.append(this.speed.getText()).append(",");
        sb.append(this.dataBits.getText()).append(",");
        sb.append(this.parity.getText()).append(",");
        sb.append(this.stopBits.getText()).append(",");
        if (this.flowControlIn.getText().equalsIgnoreCase("NONE")) {
            sb.append(0);
        }
        if (this.flowControlIn.getText().equalsIgnoreCase("RTSCTS")) {
            sb.append(1);
        }
        if (this.flowControlIn.getText().equalsIgnoreCase("XONXOFF")) {
            sb.append(4);
        }
        sb.append(",");
        if (this.flowControlOut.getText().equalsIgnoreCase("NONE")) {
            sb.append(0);
        }
        if (this.flowControlOut.getText().equalsIgnoreCase("RTSCTS")) {
            sb.append(2);
        }
        if (this.flowControlOut.getText().equalsIgnoreCase("XONXOFF")) {
            sb.append(8);
        }
        System.out.println(sb.toString());
        CoreHub.localCfg.set(PARAMS, sb.toString());
        CoreHub.localCfg.set(PORT, this.comPorts.getText());
        CoreHub.localCfg.flush();
        return super.performOk();
    }
}

