/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.connect.afinion;

import ch.elexis.connect.afinion.AfinionConnection;
import ch.elexis.connect.afinion.Logger;
import ch.elexis.connect.afinion.Messages;
import ch.elexis.connect.afinion.packages.PackageException;
import ch.elexis.connect.afinion.packages.Record;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.serial.Connection;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.importer.div.rs232.SerialConnectionUi;
import ch.elexis.core.ui.util.Log;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.LabItem;
import ch.elexis.data.Labor;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class AfinionAS100Action
extends Action
implements Connection.ComPortListener {
    AfinionConnection _ctrl;
    Labor _myLab;
    Thread msgDialogThread;
    Thread infoDialogThread;
    Patient selectedPatient;
    Logger _rs232log;
    Log _elexislog = Log.get((String)"AfinionAS100Action");
    Record lastRecord = null;
    boolean background;
    int debugRecord = 0;
    String simulate = null;

    public AfinionAS100Action() {
        super(Messages.AfinionAS100Action_ButtonName, 2);
        this.setToolTipText(Messages.AfinionAS100Action_ToolTip);
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"ch.elexis.connect.afinion", (String)"icons/afinion.png"));
    }

    private void initConnection() {
        if (this._ctrl != null && this._ctrl.isOpen()) {
            this._ctrl.close();
        }
        this._ctrl = (AfinionConnection)new AfinionConnection(Messages.AfinionAS100Action_ConnectionName, CoreHub.localCfg.get("connectors/afinion/port", Messages.AfinionAS100Action_DefaultPort), CoreHub.localCfg.get("connectors/afinion/params", Messages.AfinionAS100Action_DefaultParams), this).withStartOfChunk(new byte[]{16, 2}).withEndOfChunk((byte[][])new byte[][]{{16, 3}}).excludeDelimiters(false);
        GregorianCalendar cal = new GregorianCalendar();
        if (this.debugRecord != 0) {
            SWTHelper.showInfo((String)"Debugging!!!", (String)("Record " + this.debugRecord));
            ((Calendar)cal).add(5, -365);
        }
        ((Calendar)cal).add(10, -cal.get(11));
        cal.set(12, 0);
        cal.set(13, 0);
        this._ctrl.setCurrentDate(cal);
        if (CoreHub.localCfg.get("connectors/afinion/log", "n").equalsIgnoreCase("y")) {
            try {
                this._rs232log = new Logger(System.getProperty("user.home") + File.separator + "elexis" + File.separator + "afinion.log");
            }
            catch (FileNotFoundException e) {
                SWTHelper.showError((String)Messages.AfinionAS100Action_LogError_Title, (String)Messages.AfinionAS100Action_LogError_Text);
                this._rs232log = new Logger();
            }
        } else {
            this._rs232log = new Logger(false);
        }
        this.background = CoreHub.localCfg.get("connectors/afinion/background", "n").equalsIgnoreCase("y");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block13: {
            block12: {
                if (!this.isChecked()) break block12;
                if (this.simulate == null) {
                    this.initConnection();
                    this._rs232log.logStart();
                    if (this._ctrl.connect()) {
                        String timeoutStr = CoreHub.localCfg.get("connectors/afinion/timeout", Messages.AfinionAS100Action_DefaultTimeout);
                        int timeout = 20;
                        try {
                            timeout = Integer.parseInt(timeoutStr);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        SerialConnectionUi.awaitFrame((Connection)this._ctrl, (Shell)UiDesk.getTopShell(), (String)Messages.AfinionAS100Action_WaitMsg, (int)timeout, (boolean)this.background, (boolean)false);
                        return;
                    }
                    this._rs232log.log("Error");
                    SWTHelper.showError((String)Messages.AfinionAS100Action_RS232_Error_Title, (String)"Konnte seriellen Port nicht \u00f6ffnen");
                    break block13;
                } else {
                    SWTHelper.showInfo((String)"Simulating!!!", (String)this.simulate);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try {
                        FileInputStream inputStream = new FileInputStream(this.simulate);
                        int test = inputStream.read();
                        int ETX = 3;
                        int DLE = 16;
                        block5: while (test != -1 && test != ETX) {
                            while (true) {
                                if (test == -1 || test == DLE) {
                                    test = inputStream.read();
                                    continue block5;
                                }
                                baos.write(test);
                                test = inputStream.read();
                            }
                        }
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    byte[] data = baos.toByteArray();
                    this.gotData(null, data);
                }
                break block13;
            }
            if (this._ctrl.isOpen()) {
                this._ctrl.sendBreak();
                this._ctrl.close();
            }
        }
        this.setChecked(false);
        this._rs232log.logEnd();
    }

    public void gotBreak(Connection connection) {
        connection.close();
        this.setChecked(false);
        this._rs232log.log("Break");
        this._rs232log.logEnd();
        SWTHelper.showError((String)Messages.AfinionAS100Action_RS232_Break_Title, (String)Messages.AfinionAS100Action_RS232_Break_Text);
    }

    private byte[] subBytes(byte[] bytes, int pos, int length) {
        byte[] retVal = new byte[length];
        int i = 0;
        while (i < length) {
            retVal[i] = bytes[pos + i];
            ++i;
        }
        return retVal;
    }

    private void processRecord(final Record record) {
        UiDesk.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                AfinionAS100Action.this.selectedPatient = ElexisEventDispatcher.getSelectedPatient();
                Patient probePat = null;
                String vorname = null;
                String name = null;
                Object patientElexisStr = Messages.AfinionAS100Action_UnknownPatientHeaderString;
                String patientDeviceStr = record.getId();
                Long patId = null;
                if (patientDeviceStr != null) {
                    Query patQuery = new Query(Patient.class);
                    if (patientDeviceStr != null && patientDeviceStr.length() > 0) {
                        List patientList;
                        String[] parts = patientDeviceStr.split(",");
                        if (parts.length > 1) {
                            try {
                                patId = new Long(parts[0]);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (patId != null) {
                                name = AfinionAS100Action.this.getFirstUpper(parts[1]);
                            } else {
                                name = AfinionAS100Action.this.getFirstUpper(parts[0]);
                                vorname = AfinionAS100Action.this.getFirstUpper(parts[1]);
                                patQuery.add("Vorname", "like", vorname + "%");
                            }
                        } else if (parts.length == 1) {
                            try {
                                patId = new Long(patientDeviceStr);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (patId == null) {
                                name = AfinionAS100Action.this.getFirstUpper(patientDeviceStr);
                            }
                        }
                        if (patId != null) {
                            patQuery.add("PatientNr", "=", patId.toString());
                        }
                        if (name != null && name.length() > 0) {
                            patQuery.add("Name", "like", name + "%");
                        }
                        if (vorname != null && vorname.length() > 0) {
                            patQuery.add("Vorname", "like", vorname + "%");
                        }
                        if ((patientList = patQuery.execute()).size() == 1) {
                            probePat = (Patient)patientList.get(0);
                            patientDeviceStr = record.getId();
                            patientElexisStr = probePat.getName() + " " + probePat.getVorname();
                        }
                    }
                }
                if (patientDeviceStr == null || patientDeviceStr.equals("")) {
                    patientDeviceStr = Messages.AfinionAS100Action_NoPatientInfo;
                }
                String warning = "";
                String text = MessageFormat.format(Messages.AfinionAS100Action_ValueInfoMsg, patientDeviceStr, patientElexisStr, record.getRunNr(), record.getText(), warning);
                boolean ok = MessageDialog.openConfirm((Shell)UiDesk.getTopShell(), (String)Messages.AfinionAS100Action_DeviceName, (String)text);
                if (ok) {
                    boolean showSelectionDialog = false;
                    if (probePat != null) {
                        AfinionAS100Action.this.selectedPatient = probePat;
                    } else {
                        showSelectionDialog = true;
                    }
                    if (showSelectionDialog) {
                        UiDesk.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                KontaktSelektor ksl = new KontaktSelektor(Hub.getActiveShell(), Patient.class, Messages.AfinionAS100Action_Patient_Title, Messages.AfinionAS100Action_Patient_Text, Patient.DEFAULT_SORT);
                                ksl.create();
                                ksl.getShell().setText(Messages.AfinionAS100Action_Patient_Title);
                                (this).AfinionAS100Action.this.selectedPatient = ksl.open() == 0 ? (Patient)ksl.getSelection() : null;
                            }
                        });
                    }
                    if (AfinionAS100Action.this.selectedPatient != null) {
                        try {
                            record.write(AfinionAS100Action.this.selectedPatient);
                        }
                        catch (PackageException e) {
                            SWTHelper.showError((String)Messages.AfinionAS100Action_ProbeError_Title, (String)e.getMessage());
                        }
                    } else {
                        SWTHelper.showError((String)Messages.AfinionAS100Action_Patient_Title, (String)Messages.AfinionAS100Action_NoPatientSelectedMsg);
                    }
                    AfinionAS100Action.this._rs232log.log("Saved");
                    ElexisEventDispatcher.reload(LabItem.class);
                }
            }
        });
    }

    public void gotData(Connection connection, byte[] data) {
        if (this._rs232log != null) {
            this._rs232log.logRX(new String(data));
        }
        int pos = 0;
        int i = 0;
        int validRecords = 0;
        while (i < 10) {
            byte[] subbytes = this.subBytes(data, pos, 256);
            Record tmpRecord = new Record(subbytes);
            String text = tmpRecord.toString();
            System.out.println("DEBUG: " + text);
            this._elexislog.log(text, 5);
            if (tmpRecord.isValid()) {
                if (this.debugRecord != 0) {
                    if (tmpRecord.getRecordNum() <= this.debugRecord) {
                        this.lastRecord = tmpRecord;
                    }
                    if (tmpRecord.getRecordNum() == this.debugRecord) {
                        validRecords = 0;
                    }
                } else {
                    this.lastRecord = tmpRecord;
                }
                text = this.lastRecord.toString();
                System.out.println(text);
                this._elexislog.log(text, 4);
                ++validRecords;
            }
            pos += 256;
            ++i;
        }
        if (validRecords == 10) {
            Calendar cal = this.lastRecord.getCalendar();
            cal.add(13, 1);
            if (this._ctrl != null) {
                this._ctrl.setCurrentDate(cal);
                this._ctrl.setState(2);
            }
        } else {
            if (this._ctrl != null) {
                this._ctrl.setState(99);
                this._ctrl.close();
            }
            this.setChecked(false);
            if (this.lastRecord != null) {
                this.processRecord(this.lastRecord);
            } else {
                SWTHelper.showInfo((String)Messages.AfinionAS100Action_DeviceName, (String)Messages.AfinionAS100Action_NoValuesMsg);
            }
            this._rs232log.log("Saved");
            ElexisEventDispatcher.reload(LabItem.class);
        }
    }

    public void closed() {
        this._rs232log.log("Closed");
        this.setChecked(false);
        this._rs232log.logEnd();
    }

    public void cancelled() {
        this._ctrl.close();
        this._rs232log.log("Cancelled");
        this.setChecked(false);
        this._rs232log.logEnd();
    }

    public void timeout() {
        this._ctrl.close();
        this._rs232log.log("Timeout");
        SWTHelper.showError((String)Messages.AfinionAS100Action_RS232_Timeout_Title, (String)Messages.AfinionAS100Action_RS232_Timeout_Text);
        this.setChecked(false);
        this._rs232log.logEnd();
    }

    private String getFirstUpper(String str) {
        if (str == null) {
            return null;
        }
        str = str.trim();
        Object retStr = str.toUpperCase();
        if (str.length() > 1) {
            retStr = str.substring(0, 1).toUpperCase() + str.substring(1).trim();
        }
        return retStr;
    }
}

