/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.connect.afinion.packages;

import ch.elexis.connect.afinion.packages.AbstractPart;
import java.text.DecimalFormat;

public class SubRecordPart
extends AbstractPart {
    private float min;
    private float max;
    private float result;
    private int decimals;
    private boolean valid;
    private boolean outOfRange;
    private String unit;
    private String kuerzel;

    public SubRecordPart(byte[] bytes, int pos) {
        this.parse(bytes, pos);
    }

    public void parse(byte[] bytes, int pos) {
        this.min = this.getFloat(bytes, pos);
        this.max = this.getFloat(bytes, pos + 4);
        this.result = this.getFloat(bytes, pos + 8);
        this.decimals = this.getInteger(bytes, pos + 12);
        this.valid = this.getInteger(bytes, pos + 16) > 0;
        this.unit = this.getString(bytes, pos + 20, 9);
        this.kuerzel = this.getString(bytes, pos + 29, 9);
        this.outOfRange = false;
        if (this.result < this.min || this.result > this.max) {
            this.outOfRange = true;
        }
    }

    @Override
    public int length() {
        return 40;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getResult() {
        return this.result;
    }

    public String getResultStr() {
        if (this.result < this.min) {
            return "<" + new DecimalFormat("#.##").format(this.min);
        }
        if (this.result > this.max) {
            return ">" + new DecimalFormat("#.##").format(this.max);
        }
        return new DecimalFormat("#.##").format(this.result);
    }

    public int getDecimals() {
        return this.decimals;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isOutOfRange() {
        return this.outOfRange;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getKuerzel() {
        return this.kuerzel;
    }

    public String toString() {
        DecimalFormat nf = new DecimalFormat("###.##");
        Object str = "";
        str = (String)str + " " + this.kuerzel + ": " + nf.format(this.result) + this.unit + ";";
        str = (String)str + " Min:" + nf.format(this.min) + ";";
        str = (String)str + " Max:" + nf.format(this.max) + ";";
        str = (String)str + " Decimals:" + this.decimals + ";";
        str = (String)str + " OutOfRange:" + this.outOfRange + ";";
        str = (String)str + " Valid:" + this.valid + ";";
        return str;
    }
}

