/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.connect.afinion;

import ch.elexis.core.serial.Connection;
import ch.elexis.core.ui.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.slf4j.LoggerFactory;

public class AfinionConnection
extends Connection {
    Log _elexislog = Log.get((String)"AfinionConnection");
    protected static final int NUL = 0;
    protected static final int STX = 2;
    protected static final int ETX = 3;
    protected static final int ACK = 6;
    protected static final int DLE = 16;
    protected static final int NAK = 21;
    protected static final int ETB = 23;
    protected static final int LF = 13;
    private static final long STARTUP_DELAY_IN_MS = 2000L;
    private static final long RESEND_IN_MS = 30000L;
    public static final int INIT = 0;
    public static final int WAITING = 1;
    public static final int SEND_PAT_REQUEST = 2;
    public static final int PAT_REQUEST_SENDED = 3;
    public static final int PAT_REQUEST_ACK = 4;
    public static final int ENDING = 99;
    private String awaitPacketNr;
    private static int pc_packet_nr = 21;
    private long last_time_ms = 0L;
    private Calendar currentCal = new GregorianCalendar();
    private int state;
    private static final boolean debugToConsole = false;

    public AfinionConnection(String portName, String port, String settings, Connection.ComPortListener l) {
        super(portName, port, settings, l);
        this.setState(0);
    }

    public void setCurrentDate(Calendar cal) {
        this.currentCal = cal;
    }

    private void debug(String text) {
        this._elexislog.log(text, 5);
    }

    private void debugln(String text) {
        this._elexislog.log(text, 5);
    }

    private static long getCrc(byte[] array) {
        int crc = 65535;
        byte[] byArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            char value = (char)b;
            value = (char)(value ^ crc & 0xFF);
            value = (char)(value ^ value << 4 & 0xFF);
            crc = (char)(crc >>> 8 ^ value << 8 ^ value << 3 ^ value >>> 4);
            ++n2;
        }
        return crc;
    }

    private String getByteStr(byte[] bytes) {
        StringBuffer strBuf = new StringBuffer();
        int counter = 1;
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (strBuf.length() > 0) {
                strBuf.append(", ");
                if (counter > 16) {
                    strBuf.append("\n");
                    counter = 1;
                }
            }
            Object byteStr = Long.toHexString(b);
            while (((String)byteStr).length() < 2) {
                byteStr = "0" + (String)byteStr;
            }
            strBuf.append("0x" + (String)byteStr);
            ++counter;
            ++n2;
        }
        return strBuf.toString();
    }

    private String getText(int value) {
        if (value == 0) {
            return "<NUL>";
        }
        if (value == 2) {
            return "<STX>";
        }
        if (value == 3) {
            return "<ETX>";
        }
        if (value == 6) {
            return "<ACK>";
        }
        if (value == 16) {
            return "<DLE>";
        }
        if (value == 21) {
            return "<NAK>";
        }
        if (value == 23) {
            return "<ETB>";
        }
        return new Character((char)value).toString();
    }

    private String nextPacketNr() {
        Object packetNrStr = new Integer(pc_packet_nr).toString();
        ++pc_packet_nr;
        while (((String)packetNrStr).length() < 4) {
            packetNrStr = "0" + (String)packetNrStr;
        }
        return packetNrStr;
    }

    private void addDate(StringBuffer strBuf) {
        int day = this.currentCal.get(5);
        int month = this.currentCal.get(2) + 1;
        int year = this.currentCal.get(1);
        int hour = this.currentCal.get(11);
        int minutes = this.currentCal.get(12);
        int seconds = this.currentCal.get(13);
        String dayStr = (day < 10 ? "0" : "") + Integer.valueOf(day).toString();
        String monthStr = (month < 10 ? "0" : "") + Integer.valueOf(month).toString();
        String yearStr = Integer.valueOf(year).toString();
        String hourStr = (hour < 10 ? "0" : "") + Integer.valueOf(hour).toString();
        String minuteStr = (minutes < 10 ? "0" : "") + Integer.valueOf(minutes).toString();
        String secondStr = (seconds < 10 ? "0" : "") + Integer.valueOf(seconds).toString();
        String dateStr = yearStr + monthStr + dayStr + " " + hourStr + ":" + minuteStr + ":" + secondStr;
        strBuf.append(dateStr);
        String text = "Request starting at:" + dateStr;
        System.out.println(text);
        this._elexislog.log(text, 4);
    }

    private void addContentStart(ByteArrayOutputStream os) {
        this.debug("<DLE>");
        os.write(16);
        this.debug("<STX>");
        os.write(2);
    }

    private void addContentEnd(ByteArrayOutputStream os) {
        this.debug("<DLE>");
        os.write(16);
        this.debug("<ETB>");
        os.write(23);
    }

    private void addEnding(ByteArrayOutputStream os) throws IOException {
        long crc = AfinionConnection.getCrc(os.toByteArray());
        Object crcStr = Long.toHexString(crc).toUpperCase();
        while (((String)crcStr).length() < 4) {
            crcStr = "0" + (String)crcStr;
        }
        this.debug((String)crcStr);
        os.write(((String)crcStr).getBytes());
        this.debug("<DLE>");
        os.write(16);
        this.debug("<ETX>");
        os.write(3);
        this.debugln("");
    }

    private void sendPacketACK(String packetNr) {
        this.debug("-->");
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.addContentStart(os);
            this.debug(packetNr);
            os.write(packetNr.getBytes());
            this.debug("<ACK>");
            os.write(6);
            this.addContentEnd(os);
            this.addEnding(os);
            this.debugln("Send: " + this.getByteStr(os.toByteArray()));
            if (this.send(os.toByteArray())) {
                this.debugln("OK");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void sendMessageACK() {
        this.debug("-->");
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.addContentStart(os);
            String packetNr = this.nextPacketNr();
            this.debug(packetNr);
            os.write(packetNr.getBytes());
            String cmdack = "0025:cmdack@";
            this.debug(cmdack);
            os.write(cmdack.getBytes());
            this.addContentEnd(os);
            this.addEnding(os);
            this.debugln("Send: " + this.getByteStr(os.toByteArray()));
            if (this.send(os.toByteArray())) {
                this.debugln("OK");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void sendPacketNAK(String packetNr) {
        this.debug("-->");
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.addContentStart(os);
            this.debug(packetNr);
            os.write(packetNr.getBytes());
            this.debug("<NAK>");
            os.write(21);
            this.addContentEnd(os);
            this.addEnding(os);
            this.debugln("Send: " + this.getByteStr(os.toByteArray()));
            if (this.send(os.toByteArray())) {
                this.debugln("OK");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String sendPatRecordRequest() {
        this.debug("-->");
        StringBuffer contentBuf = new StringBuffer();
        String packetNrStr = this.nextPacketNr();
        contentBuf.append(packetNrStr);
        contentBuf.append("0025:record,patient@");
        this.addDate(contentBuf);
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.addContentStart(os);
            this.debug(contentBuf.toString());
            os.write(contentBuf.toString().getBytes());
            this.addContentEnd(os);
            this.addEnding(os);
            this.debugln("Send: " + this.getByteStr(os.toByteArray()));
            if (this.send(os.toByteArray())) {
                this.debugln("OK");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return packetNrStr;
    }

    /*
     * Unable to fully structure code
     */
    private void readToEnd(InputStream inputStream) throws IOException {
        os = new ByteArrayOutputStream();
        data = inputStream.read();
        ** GOTO lbl9
        {
            os.write(data);
            data = inputStream.read();
            do {
                if (data != -1 && data != 16) continue block0;
                data = inputStream.read();
lbl9:
                // 2 sources

            } while (data != -1 && data != 3);
        }
        this.debug(os.toString());
        this.debugln("<DLE><ETX>");
    }

    private void readToLF(InputStream inputStream) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int data = inputStream.read();
        while (data != -1 && data != 13) {
            os.write(data);
            data = inputStream.read();
        }
        this.debug("...");
        this.debugln("<LF>");
    }

    private void readToEndAndACK(String packetNr, InputStream inputStream) throws IOException {
        this.readToEnd(inputStream);
        this.debugln("");
        if (packetNr != null) {
            this.sendPacketACK(packetNr);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void handlePatientRecord(String packetNr, InputStream inputStream) throws IOException {
        baos = new ByteArrayOutputStream();
        data = inputStream.read();
        ** GOTO lbl14
        {
            baos.write(data);
            data = inputStream.read();
            do {
                if (data != -1 && data != 16) continue block0;
                if (data != 16) continue;
                baos.write(data);
                data = inputStream.read();
                if (data != 16) {
                    baos.write(data);
                }
                data = inputStream.read();
lbl14:
                // 3 sources

            } while (data != -1 && data != 23);
        }
        bytes = baos.toByteArray();
        this.debug(this.getByteStr(bytes));
        this.debugln("<DLE><ETB>");
        this.readToEnd(inputStream);
        if (bytes.length < 2560) {
            this.sendPacketNAK(packetNr);
        } else {
            this.sendPacketACK(packetNr);
            this.sendMessageACK();
            this.getListener().gotData((Connection)this, bytes);
        }
    }

    private void dataAvailable(InputStream inputStream) throws IOException {
        long time_ms;
        long time_ms2;
        this.debug("<--");
        int data = inputStream.read();
        if (data == 16) {
            this.debug("<DLE>");
            data = inputStream.read();
            if (data == 2) {
                this.debug("<STX>");
                Object packetNr = "";
                int i = 0;
                while (i < 4) {
                    data = inputStream.read();
                    packetNr = (String)packetNr + (char)data;
                    ++i;
                }
                this.debug((String)packetNr);
                data = inputStream.read();
                if (data == 21) {
                    this.debug("<NAK>");
                    data = inputStream.read();
                    this.debug(this.getText(data));
                    data = inputStream.read();
                    this.debug(this.getText(data));
                    this.readToEnd(inputStream);
                } else if (data == 6) {
                    this.debug("<ACK>");
                    data = inputStream.read();
                    this.debug(this.getText(data));
                    data = inputStream.read();
                    this.debug(this.getText(data));
                    this.readToEnd(inputStream);
                    if (((String)packetNr).equals(this.awaitPacketNr)) {
                        this.setState(4);
                    }
                } else {
                    StringBuffer header = new StringBuffer();
                    while (data != -1 && data != 64) {
                        header.append((char)data);
                        data = inputStream.read();
                    }
                    String headerStr = header.toString();
                    this.debug(headerStr);
                    this.debug("@");
                    if (headerStr.indexOf("0025:record,patient") != -1) {
                        if (this.getState() == 4) {
                            this.handlePatientRecord((String)packetNr, inputStream);
                        } else {
                            this.readToEndAndACK((String)packetNr, inputStream);
                        }
                    } else if (headerStr.indexOf("0024:record.control") != -1) {
                        this.readToEndAndACK((String)packetNr, inputStream);
                    } else if (headerStr.indexOf("cmdack") != -1) {
                        this.readToEndAndACK((String)packetNr, inputStream);
                    } else if (headerStr.indexOf("cmderr") != -1) {
                        this.readToEndAndACK((String)packetNr, inputStream);
                    } else if (headerStr.indexOf("cmdcmpl") != -1) {
                        this.readToEndAndACK((String)packetNr, inputStream);
                    } else if (headerStr.indexOf("debugmsg") != -1) {
                        this.readToEndAndACK((String)packetNr, inputStream);
                    } else if (headerStr.indexOf("FFFF:IC") != -1) {
                        this.readToEndAndACK((String)packetNr, inputStream);
                    }
                }
            } else {
                this.readToEnd(inputStream);
            }
        } else {
            this.readToLF(inputStream);
        }
        if (this.getState() == 0) {
            this.last_time_ms = new GregorianCalendar().getTimeInMillis();
            this.setState(1);
        }
        if (this.getState() == 1 && (time_ms2 = new GregorianCalendar().getTimeInMillis()) - this.last_time_ms > 2000L) {
            this.setState(2);
            this.last_time_ms = new GregorianCalendar().getTimeInMillis();
        }
        if ((this.getState() == 3 || this.getState() == 4) && (time_ms = new GregorianCalendar().getTimeInMillis()) - this.last_time_ms > 30000L) {
            this.setState(2);
            this.last_time_ms = new GregorianCalendar().getTimeInMillis();
        }
        if (this.getState() == 2) {
            this.awaitPacketNr = this.sendPatRecordRequest();
            this.setState(3);
        }
    }

    protected void fireData(byte[] data) {
        if (data != null && data.length > 0) {
            try {
                this.dataAvailable(new ByteArrayInputStream(data));
            }
            catch (IOException e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error fire available serial data", (Throwable)e);
            }
        }
    }

    public boolean connect() {
        this.setState(0);
        return super.connect();
    }

    private String getStateText(int state) {
        switch (state) {
            case 0: {
                return "INIT";
            }
            case 1: {
                return "WAITING";
            }
            case 2: {
                return "SEND_PAT_REQUEST";
            }
            case 3: {
                return "SEND_PAT_REQUEST";
            }
            case 4: {
                return "SEND_PAT_REQUEST";
            }
        }
        return "#" + state;
    }

    public void setState(int state) {
        this.debugln(this.getStateText(this.getState()) + " -> " + this.getStateText(state));
        this.state = state;
    }

    public int getState() {
        return this.state;
    }
}

