/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.solr.task;

import ch.elexis.base.solr.task.DocumentIndexerIdentifiedRunnable;
import ch.elexis.base.solr.task.EncounterIndexerIdentifiedRunnable;
import ch.elexis.base.solr.task.LetterIndexerIdentifiedRunnable;
import ch.elexis.base.solr.task.SolrIndexerIdentifiedRunnableTaskDescriptor;
import ch.elexis.core.model.tasks.IIdentifiedRunnable;
import ch.elexis.core.model.tasks.IIdentifiedRunnableFactory;
import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.services.IAccessControlService;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.tasks.model.ITaskService;
import io.quarkus.runtime.Startup;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Startup
@Component(immediate=true)
public class SolrIndexerIdentifiedRunnableFactory
implements IIdentifiedRunnableFactory {
    @Inject
    @Reference
    ITaskService taskService;
    @Inject
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    IModelService coreModelService;
    @Inject
    @Reference(target="(service.model.name=ch.elexis.omnivore.data.model)")
    IModelService omnivoreModelService;
    @Inject
    @Reference
    IConfigService configService;
    @Inject
    @Reference
    IAccessControlService accessControlService;

    public List<IIdentifiedRunnable> getProvidedRunnables() {
        ArrayList<IIdentifiedRunnable> ret = new ArrayList<IIdentifiedRunnable>();
        ret.add(new EncounterIndexerIdentifiedRunnable(this.coreModelService, this.configService));
        ret.add(new LetterIndexerIdentifiedRunnable(this.coreModelService));
        ret.add(new DocumentIndexerIdentifiedRunnable(this.omnivoreModelService));
        return ret;
    }

    @PostConstruct
    @Activate
    public void activate() {
        this.accessControlService.doPrivileged(() -> {
            try {
                SolrIndexerIdentifiedRunnableTaskDescriptor.getOrCreateForEncounter(this.taskService);
                SolrIndexerIdentifiedRunnableTaskDescriptor.getOrCreateForLetter(this.taskService);
                SolrIndexerIdentifiedRunnableTaskDescriptor.getOrCreateForDocument(this.taskService);
            }
            catch (TaskException e) {
                LoggerFactory.getLogger(this.getClass()).error("initialize", (Throwable)e);
                throw new ComponentException((Throwable)e);
            }
            this.taskService.bindIIdentifiedRunnableFactory((IIdentifiedRunnableFactory)this);
        });
    }

    @PreDestroy
    @Deactivate
    public void deactivate() {
        this.taskService.unbindIIdentifiedRunnableFactory((IIdentifiedRunnableFactory)this);
    }
}

