/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.solr.task;

import ch.elexis.base.solr.internal.bean.EncounterBean;
import ch.elexis.base.solr.task.AbstractIndexerIdentifiedRunnable;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.tasks.SingleIdentifiableTaskResult;
import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IQueryCursor;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.apache.solr.common.SolrDocument;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;

public class EncounterIndexerIdentifiedRunnable
extends AbstractIndexerIdentifiedRunnable {
    public static final String RUNNABLE_ID = "solrEncounterIndexer";
    public static final String DESCRIPTION = "Index encouters into SOLR";
    private IModelService coreModelService;
    private IConfigService configService;

    public EncounterIndexerIdentifiedRunnable(IModelService coreModelService, IConfigService configService) {
        this.coreModelService = coreModelService;
        this.configService = configService;
    }

    public String getId() {
        return RUNNABLE_ID;
    }

    public String getLocalizedDescription() {
        return DESCRIPTION;
    }

    public Map<String, Serializable> run(Map<String, Serializable> runContext, IProgressMonitor progressMonitor, Logger logger) throws TaskException {
        super.init(runContext);
        HttpSolrClient.Builder solrClientBuilder = super.getSolrClientBuilder();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (HttpSolrClient solr = solrClientBuilder.build();){
                this.checkResponse((SolrResponseBase)solr.ping("el-encounters"));
                String lastIndexRunLastUpdateString = this.configService.get("solrIndexer/LU_lastIndexRun_encounter", "0");
                Long lastIndexRunLastUpdate = Long.valueOf(lastIndexRunLastUpdateString);
                long newestLastUpdate = this.indexEncounters(solr, lastIndexRunLastUpdate, progressMonitor, logger, this.failures);
                this.configService.set("solrIndexer/LU_lastIndexRun_encounter", Long.toString(newestLastUpdate), false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | SolrServerException e) {
            throw new TaskException(6, e);
        }
        return this.resultMap;
    }

    private long indexEncounters(HttpSolrClient solr, Long lastIndexRunLastUpdate, IProgressMonitor progressMonitor, Logger logger, ArrayList<SingleIdentifiableTaskResult> failures) throws SolrServerException, IOException {
        IQuery query = this.coreModelService.getQuery(IEncounter.class, true);
        query.and((EStructuralFeature)ModelPackage.Literals.IENCOUNTER__COVERAGE, IQuery.COMPARATOR.NOT_EQUALS, null);
        query.and((EStructuralFeature)ModelPackage.Literals.IDENTIFIABLE__LASTUPDATE, IQuery.COMPARATOR.GREATER, (Object)lastIndexRunLastUpdate);
        query.orderBy((EStructuralFeature)ModelPackage.Literals.IDENTIFIABLE__LASTUPDATE, IQuery.ORDER.ASC);
        query.limit(100000);
        int noIndexed = 0;
        int noRemovedFromIndex = 0;
        long newestLastUpdate = lastIndexRunLastUpdate;
        Throwable throwable = null;
        Object var12_12 = null;
        try (IQueryCursor encounterCursor = query.executeAsCursor();){
            while (encounterCursor.hasNext()) {
                IEncounter encounter = (IEncounter)encounterCursor.next();
                try {
                    if (encounter.isDeleted()) {
                        SolrDocument document = solr.getById("el-encounters", encounter.getId());
                        if (document != null) {
                            this.checkResponse((SolrResponseBase)solr.deleteById("el-encounters", encounter.getId()));
                            ++noRemovedFromIndex;
                        }
                    } else {
                        EncounterBean iEncounterBean = EncounterBean.of(encounter);
                        this.checkResponse((SolrResponseBase)solr.addBean("el-encounters", (Object)iEncounterBean));
                        ++noIndexed;
                    }
                    if (encounter.getLastupdate() > newestLastUpdate) {
                        newestLastUpdate = encounter.getLastupdate();
                    }
                }
                catch (IOException | IllegalArgumentException | SolrServerException e) {
                    logger.warn("addBean exception on encounter [{}]", (Object)encounter.getId(), (Object)e);
                    failures.add(new SingleIdentifiableTaskResult(StoreToStringServiceHolder.getStoreToString((Object)encounter), "commit", e.getMessage()));
                }
                encounterCursor.clear();
                if (progressMonitor.isCanceled()) {
                } else if (!super.checkIsOverMaxRunTime()) continue;
                break;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.checkResponse((SolrResponseBase)solr.commit("el-encounters"));
        this.resultMap.put("resultData", noIndexed + " indexed / " + noRemovedFromIndex + " removed from index. Indexed LU " + String.valueOf(lastIndexRunLastUpdate) + " -> " + newestLastUpdate);
        if (noIndexed == 0 && noRemovedFromIndex == 0 && failures.size() == 0) {
            this.resultMap.put("markerDoNotPersist", true);
        }
        return newestLastUpdate;
    }
}

