/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.solr.task;

import ch.elexis.base.solr.task.SolrIndexerUtil;
import ch.elexis.core.eenv.IElexisEnvironmentService;
import ch.elexis.core.model.tasks.IIdentifiedRunnable;
import ch.elexis.core.model.tasks.SingleIdentifiableTaskResult;
import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.slf4j.LoggerFactory;

public abstract class AbstractIndexerIdentifiedRunnable
implements IIdentifiedRunnable {
    public static final String RCP_STRING_SERVICE_URL = "service_url";
    public static final String RCP_STRING_MAX_RUNTIME_SECONDS = "maxRuntimeInSeconds";
    public static final String RCP_STRING_MAX_RUNTIME_SECONDS_DEFAULT = "480";
    private String solrServiceUrl;
    private SolrIndexerUtil util;
    private long startTime;
    private int maxRunTime;
    protected ArrayList<SingleIdentifiableTaskResult> failures;
    protected Map<String, Serializable> resultMap;

    public Map<String, Serializable> getDefaultRunContext() {
        HashMap<String, Serializable> defaultRunContext = new HashMap<String, Serializable>();
        Optional eeService = OsgiServiceUtil.getService(IElexisEnvironmentService.class);
        if (eeService.isPresent()) {
            defaultRunContext.put(RCP_STRING_SERVICE_URL, (Serializable)((Object)((IElexisEnvironmentService)eeService.get()).getSolrBaseUrl()));
        }
        defaultRunContext.put(RCP_STRING_MAX_RUNTIME_SECONDS, (Serializable)((Object)RCP_STRING_MAX_RUNTIME_SECONDS_DEFAULT));
        return defaultRunContext;
    }

    public void init(Map<String, Serializable> runContext) throws TaskException {
        this.failures = new ArrayList();
        this.resultMap = new HashMap<String, Serializable>();
        this.util = new SolrIndexerUtil();
        this.solrServiceUrl = (String)((Object)runContext.get(RCP_STRING_SERVICE_URL));
        if (this.solrServiceUrl == null || !this.solrServiceUrl.startsWith("http")) {
            throw new TaskException(1, "Invalid service url provided.");
        }
        this.startTime = System.currentTimeMillis();
        this.maxRunTime = Integer.valueOf((String)((Object)runContext.get(RCP_STRING_MAX_RUNTIME_SECONDS)));
    }

    public HttpSolrClient.Builder getSolrClientBuilder() {
        HttpSolrClient.Builder solrClientBuilder = new HttpSolrClient.Builder(this.solrServiceUrl);
        solrClientBuilder.withConnectionTimeout(5000);
        solrClientBuilder.withSocketTimeout(10000);
        Optional contextService = OsgiServiceUtil.getService(IContextService.class);
        Optional eeService = OsgiServiceUtil.getService(IElexisEnvironmentService.class);
        if (contextService.isPresent() && eeService.isPresent() && "ELEXIS-SERVER".equals(((IContextService)contextService.get()).getStationIdentifier())) {
            String solrPassword = System.getenv("X_EE_SOLR_ELEXIS_SERVER_PASSWORD");
            if (StringUtils.isNotBlank((CharSequence)solrPassword)) {
                HttpClient httpClient = this.createBasicAuthHttpClient("ELEXIS-SERVER", solrPassword);
                solrClientBuilder.withHttpClient(httpClient);
            } else {
                LoggerFactory.getLogger(this.getClass()).error("Combination EE/ES found, but password is blank in env X_EE_SOLR_ELEXIS_SERVER_PASSWORD");
            }
        }
        return solrClientBuilder;
    }

    public SolrIndexerUtil getUtil() {
        return this.util;
    }

    protected void checkResponse(SolrResponseBase response) throws SolrServerException {
        if (response.getStatus() != 0) {
            throw new SolrServerException("solr response is " + response.getStatus());
        }
    }

    public boolean checkIsOverMaxRunTime() {
        long currentTime = System.currentTimeMillis();
        long runTimeInSeconds = (currentTime - this.startTime) / 1000L;
        return runTimeInSeconds >= (long)(this.maxRunTime + 10);
    }

    public boolean isSingleton() {
        return true;
    }

    private HttpClient createBasicAuthHttpClient(String username, String password) {
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)provider);
        clientBuilder.addInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuthInterceptor());
        return clientBuilder.build();
    }

    private class PreemptiveAuthInterceptor
    implements HttpRequestInterceptor {
        private PreemptiveAuthInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() == null) {
                HttpHost targetHost;
                CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                Credentials credentials = credsProvider.getCredentials(new AuthScope((targetHost = (HttpHost)context.getAttribute("http.target_host")).getHostName(), targetHost.getPort()));
                if (credentials == null) {
                    throw new HttpException("No credentials provided for preemptive authentication.");
                }
                authState.update((AuthScheme)new BasicScheme(), credentials);
            }
        }
    }
}

