/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.messages;

import ch.elexis.base.messages.MsgDetailDialog;
import ch.elexis.core.data.events.Heartbeat;
import ch.elexis.core.model.IMessage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.UiDesk;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgHeartListener
implements Heartbeat.HeartListener {
    static Logger log = LoggerFactory.getLogger(MsgHeartListener.class);
    boolean bSkip;

    public void heartbeat() {
        if (!this.bSkip) {
            ContextServiceHolder.get().getActiveUserContact().ifPresent(uc -> {
                List res = CoreModelServiceHolder.get().getQuery(IMessage.class).and("destination", IQuery.COMPARATOR.EQUALS, (Object)uc.getId()).execute();
                if (!res.isEmpty()) {
                    UiDesk.getDisplay().asyncExec(() -> {
                        if (!this.isModalShellOpen()) {
                            this.bSkip = true;
                            if (ConfigServiceHolder.getUser((String)"messages/playsound", (boolean)true)) {
                                this.playSound();
                            }
                            new MsgDetailDialog(Hub.getActiveShell(), (IMessage)res.get(0)).open();
                            this.bSkip = false;
                        }
                    });
                }
            });
        }
    }

    private boolean isModalShellOpen() {
        return Arrays.asList(Display.getDefault().getShells()).stream().filter(s -> (s.getStyle() & 0x20000) > 0 || (s.getStyle() & 0x10000) > 0).findFirst().isPresent();
    }

    private void playSound() {
        try {
            AudioInputStream audioInStream;
            String soundFilePath = ConfigServiceHolder.getUser((String)"messages/soundpath", (String)"/sounds/notify_sound.wav");
            if ("/sounds/notify_sound.wav".equals(soundFilePath)) {
                URL sound = this.getClass().getResource(soundFilePath);
                audioInStream = AudioSystem.getAudioInputStream(sound);
            } else {
                File soundFile = new File(soundFilePath);
                if (!soundFile.exists()) {
                    log.warn("Sound file [" + soundFilePath + "] not found");
                    return;
                }
                audioInStream = AudioSystem.getAudioInputStream(soundFile);
            }
            DataLine.Info info = new DataLine.Info(Clip.class, audioInStream.getFormat());
            Clip clip = (Clip)AudioSystem.getLine(info);
            clip.open(audioInStream);
            clip.start();
        }
        catch (Exception e) {
            log.error("Could not play message sound", (Throwable)e);
            return;
        }
    }
}

