/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.messages;

import ch.elexis.base.messages.Messages;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.format.UserFormatUtil;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MessagePreferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String DEF_SOUND_PATH = "/sounds/notify_sound.wav";
    private Text txtSoundFilePath;
    private Button btnBrowse;
    private Button btnSoundOn;
    private Button btnAnswerAutoclear;
    private ComboViewer comboDefaultRecipient;
    private boolean soundOn = ConfigServiceHolder.getUser((String)"messages/playsound", (boolean)true);
    private boolean answerAutoclear;
    String soundFilePath = ConfigServiceHolder.getUser((String)"messages/soundpath", (String)"/sounds/notify_sound.wav");

    public MessagePreferences() {
        super(Messages.Prefs_Messages);
        this.answerAutoclear = ConfigServiceHolder.getUser((String)"messages/answer/autoclear", (boolean)false);
    }

    protected Control createContents(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout(1, false));
        Group grpSound = new Group(ret, 0);
        grpSound.setLayout((Layout)new GridLayout(2, false));
        GridData gd_grpSound = new GridData(4, 4, true, false, 1, 1);
        grpSound.setLayoutData((Object)gd_grpSound);
        grpSound.setText(Messages.Prefs_SoundSettings);
        this.btnSoundOn = new Button((Composite)grpSound, 32);
        this.btnSoundOn.setText(Messages.Prefs_TurnOnSound);
        this.btnSoundOn.setSelection(this.soundOn);
        this.btnSoundOn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessagePreferences.this.txtSoundFilePath.setEnabled(MessagePreferences.this.btnSoundOn.getSelection());
                MessagePreferences.this.btnBrowse.setEnabled(MessagePreferences.this.btnSoundOn.getSelection());
            }
        });
        new Label((Composite)grpSound, 0);
        this.txtSoundFilePath = new Text((Composite)grpSound, 2048);
        this.txtSoundFilePath.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtSoundFilePath.setText(this.soundFilePath);
        this.txtSoundFilePath.setEnabled(this.soundOn);
        this.btnBrowse = new Button((Composite)grpSound, 0);
        this.btnBrowse.setText(Messages.Prefs_BrowseFS);
        this.btnBrowse.setEnabled(this.soundOn);
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(MessagePreferences.this.btnBrowse.getShell(), 4096);
                fd.setText(Messages.Prefs_FS_Open);
                fd.setFilterPath("C:/");
                String[] filterExt = new String[]{"*.wav"};
                fd.setFilterExtensions(filterExt);
                String filePath = fd.open();
                if (filePath != null) {
                    MessagePreferences.this.txtSoundFilePath.setText(filePath);
                }
            }
        });
        Group grpDialogConfig = new Group(ret, 0);
        grpDialogConfig.setLayout((Layout)new GridLayout(1, false));
        grpDialogConfig.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        grpDialogConfig.setText(Messages.Prefs_DialogSettings);
        this.btnAnswerAutoclear = new Button((Composite)grpDialogConfig, 32);
        this.btnAnswerAutoclear.setText(Messages.Prefs_btnAnswerAutoclear);
        this.btnAnswerAutoclear.setSelection(this.answerAutoclear);
        Group grpDefaultRecipient = new Group(ret, 0);
        grpDefaultRecipient.setLayout((Layout)new GridLayout(2, false));
        grpDefaultRecipient.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpDefaultRecipient.setText(Messages.Prefs_DefaultMessageRecipient);
        Label lblActiveUser = new Label((Composite)grpDefaultRecipient, 0);
        lblActiveUser.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblActiveUser.setText(Messages.Benutzer + ": " + UserFormatUtil.getUserLabel((IContact)((IContact)ContextServiceHolder.get().getActiveUserContact().get())) + " ");
        this.comboDefaultRecipient = new ComboViewer((Composite)grpDefaultRecipient, 8);
        this.comboDefaultRecipient.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboDefaultRecipient.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IContact) {
                    IContact anwender = (IContact)element;
                    return UserFormatUtil.getUserLabel((IContact)anwender);
                }
                return super.getText(element);
            }
        });
        this.comboDefaultRecipient.setInput(this.getUsers());
        String preferenceKey = this.getPreferenceKeyForUser();
        String savedRecipientId = ConfigServiceHolder.getUser((String)preferenceKey, null);
        if (savedRecipientId != null && !savedRecipientId.isEmpty()) {
            List<IContact> users = this.getUsers();
            for (IContact user : users) {
                if (!user.getId().equals(savedRecipientId)) continue;
                this.comboDefaultRecipient.setSelection((ISelection)new StructuredSelection((Object)user));
                break;
            }
        }
        return ret;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        ConfigServiceHolder.setUser((String)"messages/playsound", (boolean)true);
        ConfigServiceHolder.setUser((String)"messages/soundpath", (String)DEF_SOUND_PATH);
        ConfigServiceHolder.setUser((String)"messages/answer/autoclear", (boolean)false);
        this.btnAnswerAutoclear.setSelection(false);
        this.btnSoundOn.setSelection(true);
        this.btnBrowse.setEnabled(true);
        this.txtSoundFilePath.setEnabled(true);
        this.txtSoundFilePath.setText(ConfigServiceHolder.getUser((String)"messages/soundpath", (String)DEF_SOUND_PATH));
        super.performDefaults();
    }

    public boolean performOk() {
        StructuredSelection selection = (StructuredSelection)this.comboDefaultRecipient.getSelection();
        IContact selectedUser = (IContact)selection.getFirstElement();
        String selectedUserId = selectedUser.getId();
        String preferenceKey = this.getPreferenceKeyForUser();
        ConfigServiceHolder.setUser((String)preferenceKey, (String)selectedUserId);
        ConfigServiceHolder.setUser((String)"messages/playsound", (boolean)this.btnSoundOn.getSelection());
        ConfigServiceHolder.setUser((String)"messages/soundpath", (String)this.txtSoundFilePath.getText());
        ConfigServiceHolder.setUser((String)"messages/answer/autoclear", (boolean)this.btnAnswerAutoclear.getSelection());
        return super.performOk();
    }

    private List<IContact> getUsers() {
        IQuery userQuery = CoreModelServiceHolder.get().getQuery(IUser.class);
        userQuery.and((EStructuralFeature)ModelPackage.Literals.IUSER__ASSIGNED_CONTACT, IQuery.COMPARATOR.NOT_EQUALS, null);
        List users = userQuery.execute();
        return users.stream().filter(u -> this.isActive((IUser)u)).map(u -> u.getAssignedContact()).collect(Collectors.toList());
    }

    private boolean isActive(IUser user) {
        IMandator mandator;
        if (user == null || user.getAssignedContact() == null) {
            return false;
        }
        if (!user.isActive()) {
            return false;
        }
        return user.getAssignedContact() == null || !user.getAssignedContact().isMandator() || (mandator = (IMandator)CoreModelServiceHolder.get().load(user.getAssignedContact().getId(), IMandator.class).orElse(null)) == null || mandator.isActive();
    }

    private String getPreferenceKeyForUser() {
        String userId = ((IContact)ContextServiceHolder.get().getActiveUserContact().get()).getId();
        return "messages/default_recipient_" + userId;
    }
}

