/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.konsextension.bildanzeige;

import ch.elexis.base.konsextension.bildanzeige.Messages;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.ImageSize;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.images.Bild;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BildImportDialog
extends TitleAreaDialog {
    ImageLoader iml;
    Image img;
    Button bJPEG;
    Button bPNG;
    Text titel;
    Text info;
    public Bild result;

    BildImportDialog(Shell shell, ImageLoader iml) {
        super(shell);
        this.iml = iml;
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        ret.setLayout((Layout)new GridLayout());
        Composite cImage = new Composite(ret, 2048);
        cImage.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.img = new Image((Device)UiDesk.getDisplay(), this.iml.data[0]);
        cImage.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                gc.drawImage(BildImportDialog.this.img, 0, 0);
            }
        });
        Group gFormat = new Group(ret, 2048);
        gFormat.setText(Messages.BildImportDialog_StorageFormat);
        this.bJPEG = new Button((Composite)gFormat, 16);
        this.bJPEG.setText(Messages.BildImportDialog_JPEG_Description);
        this.bPNG = new Button((Composite)gFormat, 16);
        this.bPNG.setText(Messages.BildImportDialog_PNG_Description);
        gFormat.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        gFormat.setLayout((Layout)new GridLayout());
        this.bJPEG.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.bPNG.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        new Label(ret, 0).setText(Messages.BildImportDialog_TitleOfImage);
        this.titel = new Text(ret, 2048);
        this.titel.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        new Label(ret, 0).setText(Messages.BildImportDialog_DescriptionOfImage);
        this.info = new Text(ret, 2050);
        this.info.setText("\n");
        this.info.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        return ret;
    }

    public void create() {
        super.create();
        this.getShell().setText(Messages.BildImportDialog_ImportCaption);
        this.setTitle(Messages.BildImportDialog_ImportTitle);
        this.setMessage(Messages.BildImportDialog_ImportMessage);
        this.setTitleImage(Images.IMG_LOGO.getImage(ImageSize._75x66_TitleDialogIconSize));
    }

    protected void okPressed() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int format = 5;
        if (this.bJPEG.getSelection()) {
            format = 4;
        }
        this.iml.save((OutputStream)baos, format);
        this.result = new Bild(ElexisEventDispatcher.getSelectedPatient(), this.titel.getText(), baos.toByteArray());
        this.result.set("Info", this.info.getText());
        this.img.dispose();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.img.dispose();
        super.cancelPressed();
    }
}

