/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.ticode;

import ch.elexis.base.ch.ticode.TessinerCode;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.ICodeElementServiceContribution;
import ch.elexis.core.services.IStoreToStringContribution;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;

@Component
public class CodeElementContribution
implements ICodeElementServiceContribution,
IStoreToStringContribution {
    public static final String STS_CLASS = "ch.elexis.data.TICode";

    public String getSystem() {
        return "TI-Code";
    }

    public ICodeElementService.CodeElementTyp getTyp() {
        return ICodeElementService.CodeElementTyp.DIAGNOSE;
    }

    public Optional<ICodeElement> loadFromCode(String code, Map<Object, Object> context) {
        return TessinerCode.getFromCode(code);
    }

    public List<ICodeElement> getElements(Map<Object, Object> context) {
        if (context.get(ICodeElementService.ContextKeys.TREE_ROOTS) != null && context.get(ICodeElementService.ContextKeys.TREE_ROOTS).equals(Boolean.TRUE)) {
            return Arrays.asList(TessinerCode.getRootNodes());
        }
        return TessinerCode.getLeafNodes();
    }

    public Optional<String> storeToString(Identifiable identifiable) {
        if (identifiable instanceof TessinerCode) {
            return Optional.of("ch.elexis.data.TICode::" + ((TessinerCode)identifiable).getId());
        }
        return Optional.empty();
    }

    public Optional<Identifiable> loadFromString(String storeToString) {
        String[] parts;
        if (storeToString != null && storeToString.startsWith(STS_CLASS) && (parts = storeToString.split("::")) != null && parts.length == 2) {
            return this.loadFromCode(parts[1]);
        }
        return Optional.empty();
    }

    public Class<?> getEntityForType(String type) {
        return null;
    }

    public String getTypeForEntity(Object entityInstance) {
        return null;
    }

    public String getTypeForModel(Class<?> interfaze) {
        return null;
    }
}

