/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.labortarif_2009.ui.dialogs;

import ch.elexis.base.ch.labortarif.ILaborLeistung;
import ch.elexis.labortarif2009.data.ModelServiceHolder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.internal.WorkbenchMessages;

public class EalSelektor
extends FilteredItemsSelectionDialog {
    private static boolean initialized = false;
    private static HashMap<ILaborLeistung, String> labelCache;
    private static List<ILaborLeistung> allCodes;

    public EalSelektor(Shell shell) {
        super(shell);
        this.setTitle("EAL Code Selektion");
        this.setListLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element == null) {
                    return "";
                }
                return labelCache.get((ILaborLeistung)element);
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        String oldListLabel = WorkbenchMessages.FilteredItemsSelectionDialog_listLabel;
        this.setMessage("");
        WorkbenchMessages.FilteredItemsSelectionDialog_listLabel = "";
        Control ret = super.createDialogArea(parent);
        WorkbenchMessages.FilteredItemsSelectionDialog_listLabel = oldListLabel;
        return ret;
    }

    protected IDialogSettings getDialogSettings() {
        return new DialogSettings("loincselector");
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new FilteredItemsSelectionDialog.ItemsFilter(this){

            public boolean isConsistentItem(Object item) {
                return true;
            }

            public boolean matchItem(Object item) {
                ILaborLeistung code = (ILaborLeistung)item;
                return this.matches(labelCache.get(code));
            }
        };
    }

    protected Comparator<ILaborLeistung> getItemsComparator() {
        return new Comparator<ILaborLeistung>(){

            @Override
            public int compare(ILaborLeistung o1, ILaborLeistung o2) {
                return labelCache.get(o1).compareTo(labelCache.get(o2));
            }
        };
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        if (!initialized) {
            labelCache = new HashMap();
            allCodes = new ArrayList<ILaborLeistung>();
            allCodes.addAll(ModelServiceHolder.get().getQuery(ILaborLeistung.class).execute());
            progressMonitor.beginTask("", allCodes.size());
            for (ILaborLeistung labor2009Tarif : allCodes) {
                if (progressMonitor.isCanceled()) {
                    return;
                }
                labelCache.put(labor2009Tarif, labor2009Tarif.getLabel());
                progressMonitor.worked(1);
            }
            initialized = true;
        }
        for (ILaborLeistung code : allCodes) {
            if (progressMonitor.isCanceled()) {
                return;
            }
            contentProvider.add((Object)code, itemsFilter);
        }
    }

    public String getElementName(Object item) {
        ILaborLeistung code = (ILaborLeistung)item;
        return labelCache.get(code);
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }
}

