/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.labortarif.model;

import ch.elexis.base.ch.labortarif.ILaborLeistung;
import ch.elexis.base.ch.labortarif.model.CodeElementServiceHolder;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IBillingSystemFactor;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.billable.AbstractOptifier;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.ICodeElementServiceContribution;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.holder.BillingServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.rgw.tools.Result;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.LoggerFactory;

public class LaborLeistungOptifier
extends AbstractOptifier<ILaborLeistung> {
    public LaborLeistungOptifier(IModelService modelService, IContextService contextService) {
        super(modelService, contextService);
    }

    private boolean isOptify() {
        Optional activeMandator = ContextServiceHolder.get().getActiveMandator();
        if (activeMandator.isPresent()) {
            return ConfigServiceHolder.get().get((IContact)activeMandator.get(), "billing/optify", true);
        }
        LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("No active Mandator, default is to optify.");
        return true;
    }

    public Result<IBilled> add(ILaborLeistung billable, IEncounter encounter, double amount, boolean save) {
        Result ret = super.add((IBillable)billable, encounter, amount, save);
        if (this.isOptify()) {
            List list = encounter.getBilled();
            boolean haveKons = false;
            IBilled v470710 = null;
            IBilled v470720 = null;
            boolean z4707 = false;
            int z470710 = 0;
            int z470720 = 0;
            for (IBilled billed : list) {
                IBillable existing = billed.getBillable();
                if (existing == null) {
                    return new Result(Result.SEVERITY.ERROR, 1, "Could not resolve billable for billed [" + billed.getId() + "] in encounter [" + encounter.getId() + "]", null, true);
                }
                if (existing instanceof ILaborLeistung) {
                    ILaborLeistung existingLaborLeistung;
                    String existingCode = existing.getCode();
                    if (existingCode.equals("4707.00")) {
                        if (z4707 < true) {
                            z4707 = true;
                            continue;
                        }
                        return new Result(Result.SEVERITY.WARNING, 1, "4707.00 only once per cons", (Object)billed, false);
                    }
                    if (existingCode.equals("4707.10")) {
                        v470710 = billed;
                        continue;
                    }
                    if (existingCode.equals("4707.20")) {
                        v470720 = billed;
                        continue;
                    }
                    if (existingCode.equals("4703.00") || existingCode.equals("4701.00") || existingCode.equals("4704.00") || existingCode.equals("4706.00") || this.isSchnellAnalyse(existingLaborLeistung = (ILaborLeistung)existing)) continue;
                    if (existingLaborLeistung.getSpeciality().indexOf("C") > -1) {
                        z470710 = (int)((double)z470710 + billed.getAmount());
                        continue;
                    }
                    z470720 = (int)((double)z470720 + billed.getAmount());
                    continue;
                }
                if (existing.getCode().equals("00.0010") || existing.getCode().equals("00.0060")) {
                    haveKons = true;
                    continue;
                }
                if (!existing.getCode().equals("AA.00.0010") && !existing.getCode().equals("CA.00.0010")) continue;
                haveKons = true;
            }
            while (4 + 2 * z470710 + z470720 > 26 && z470710 > 0) {
                --z470710;
            }
            while (4 + 2 * z470710 + z470720 > 24 && z470720 > 0) {
                --z470720;
            }
            if (z470710 == 0 || !haveKons) {
                if (v470710 != null) {
                    encounter.removeBilled(v470710);
                }
            } else {
                if (v470710 == null) {
                    v470710 = this.createBilled(encounter, "4707.10");
                }
                v470710.setAmount((double)z470710);
            }
            if (z470720 == 0 || !haveKons) {
                if (v470720 != null) {
                    encounter.removeBilled(v470720);
                }
            } else {
                if (v470720 == null) {
                    v470720 = this.createBilled(encounter, "4707.20");
                }
                v470720.setAmount((double)z470720);
            }
            if (v470710 != null && save) {
                CoreModelServiceHolder.get().save((Identifiable)v470710);
            }
            if (v470720 != null && save) {
                CoreModelServiceHolder.get().save((Identifiable)v470720);
            }
        }
        return ret;
    }

    public Result<IBilled> remove(IBilled removeBilled, IEncounter encounter) {
        Result ret = super.remove(removeBilled, encounter);
        List list = encounter.getBilled();
        boolean haveKons = false;
        IBilled v470710 = null;
        IBilled v470720 = null;
        boolean z4707 = false;
        int z470710 = 0;
        int z470720 = 0;
        for (IBilled billed : list) {
            IBillable existing = billed.getBillable();
            if (existing instanceof ILaborLeistung) {
                ILaborLeistung existingLaborLeistung;
                String existingCode = existing.getCode();
                if (existingCode.equals("4707.00")) {
                    if (z4707 < true) {
                        z4707 = true;
                        continue;
                    }
                    return new Result(Result.SEVERITY.WARNING, 1, "4707.00 only once per cons", (Object)billed, false);
                }
                if (existingCode.equals("4707.10")) {
                    v470710 = billed;
                    continue;
                }
                if (existingCode.equals("4707.20")) {
                    v470720 = billed;
                    continue;
                }
                if (existingCode.equals("4703.00") || existingCode.equals("4701.00") || existingCode.equals("4704.00") || existingCode.equals("4706.00") || this.isSchnellAnalyse(existingLaborLeistung = (ILaborLeistung)existing)) continue;
                if (existingLaborLeistung.getSpeciality().indexOf("C") > -1) {
                    z470710 = (int)((double)z470710 + billed.getAmount());
                    continue;
                }
                z470720 = (int)((double)z470720 + billed.getAmount());
                continue;
            }
            if (existing.getCode().equals("00.0010") || existing.getCode().equals("00.0060")) {
                haveKons = true;
                continue;
            }
            if (!existing.getCode().equals("AA.00.0010") && !existing.getCode().equals("CA.00.0010")) continue;
            haveKons = true;
        }
        if (z470710 == 0 || !haveKons) {
            if (v470710 != null) {
                encounter.removeBilled(v470710);
            }
        } else if (z470710 > 0 && v470710 != null && v470710.getAmount() != (double)z470710) {
            v470710.setAmount((double)z470710);
            this.coreModelService.save(v470710);
        }
        if (z470720 == 0 || !haveKons) {
            if (v470720 != null) {
                encounter.removeBilled(v470720);
            }
        } else if (z470720 > 0 && v470720 != null && v470720.getAmount() != (double)z470720) {
            v470720.setAmount((double)z470720);
            this.coreModelService.save(v470720);
        }
        return ret;
    }

    protected void setPrice(ILaborLeistung billable, IBilled billed) {
        Optional<IBillingSystemFactor> factor = this.getFactor(billed.getEncounter());
        if (factor.isPresent()) {
            billed.setFactor(factor.get().getFactor());
        } else {
            billed.setFactor(1.0);
        }
        billed.setPoints(billable.getPoints());
    }

    private IBilled createBilled(IEncounter encounter, String code) {
        Optional laborContribution = CodeElementServiceHolder.get().getContribution(ICodeElementService.CodeElementTyp.SERVICE, "EAL 2009");
        if (laborContribution.isPresent()) {
            Optional codeElement = ((ICodeElementServiceContribution)laborContribution.get()).loadFromCode(code, Collections.singletonMap(ICodeElementService.ContextKeys.CONSULTATION, encounter));
            if (codeElement.isPresent()) {
                Result result = super.add((IBillable)((ILaborLeistung)codeElement.get()), encounter, 1.0);
                return (IBilled)result.get();
            }
            throw new IllegalStateException("No labor tarif code element [" + code + "] found");
        }
        throw new IllegalStateException("No labor tarif code element contribution");
    }

    private boolean isSchnellAnalyse(ILaborLeistung laborLeistung) {
        String chapter = laborLeistung.getChapter().trim();
        if (chapter != null && !chapter.isEmpty()) {
            String[] chapters;
            String[] stringArray = chapters = chapter.split(",");
            int n = chapters.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string.trim().equals("5.1.2.2.1")) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public Optional<IBillingSystemFactor> getFactor(IEncounter encounter) {
        return BillingServiceHolder.get().getBillingSystemFactor("EAL2009", encounter.getDate());
    }
}

