/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.labortarif.model.importer;

import ch.elexis.base.ch.labortarif.Fachspec;
import ch.elexis.base.ch.labortarif.ILaborLeistung;
import ch.elexis.base.ch.labortarif.model.ModelServiceHolder;
import ch.elexis.base.ch.labortarif.model.VersionUtil;
import ch.elexis.core.importer.div.importers.ExcelWrapper;
import ch.elexis.core.interfaces.AbstractReferenceDataImporter;
import ch.elexis.core.interfaces.IReferenceDataImporter;
import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.osgi.service.component.annotations.Component;

@Component(service={IReferenceDataImporter.class}, property={"referenceDataId=analysenliste"})
public class LaborTarifReferenceDataImporter
extends AbstractReferenceDataImporter {
    private static String FLD_CODE = "code";
    private static String FLD_CHAPTER = "chapter";
    private static String FLD_TP = "tp";
    private static String FLD_NAME = "name";
    private static String FLD_LIMITATIO = "limitatio";
    private static String FLD_FACHBEREICH = "fachbereich";
    private static String FLD_GUELTIGVON = "gueltigVon";
    private static String FLD_GUELTIGBIS = "gueltigBis";
    int langdef = 0;
    LocalDate validFrom;
    Fachspec[] specs;
    int row;
    private HashMap<String, String> importedValues = new HashMap();

    public IStatus performImport(@Nullable IProgressMonitor monitor, @NonNull InputStream input, @Nullable Integer newVersion) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.validFrom = this.getValidFromVersion(newVersion).toLocalDate();
        String lang = ConfigServiceHolder.get().getLocal("ablauf/sprache", "d").toUpperCase();
        if (lang.startsWith("F")) {
            this.langdef = 1;
        } else if (lang.startsWith("I")) {
            this.langdef = 2;
        }
        this.specs = Fachspec.loadFachspecs(this.langdef);
        if (this.specs != null) {
            ExcelWrapper exw = new ExcelWrapper();
            exw.setFieldTypes(new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class});
            if (exw.load(input, this.langdef)) {
                String[] line;
                int formatYear;
                int first = exw.getFirstRow();
                int last = exw.getLastRow();
                int count = last - first;
                if (monitor != null) {
                    monitor.beginTask("Import EAL", count);
                }
                if ((formatYear = this.getFormatYear(line = exw.getRow(1).toArray(new String[0]))) != 2011 && formatYear != 2012 && formatYear != 2018) {
                    return new Status(4, "ch.elexis.base.ch.labortarif", "unknown file format");
                }
                int i = first + 1;
                while (i <= last) {
                    this.row = i;
                    line = exw.getRow(i).toArray(new String[0]);
                    if (formatYear == 2011) {
                        this.fillImportedValues2011(line);
                    } else if (formatYear == 2012) {
                        this.fillImportedValues2012(line);
                    } else if (formatYear == 2018) {
                        this.fillImportedValues2018(line);
                    }
                    if (this.importedValues.size() > 0) {
                        this.updateOrCreateFromImportedValues();
                    }
                    if (monitor != null) {
                        monitor.worked(1);
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                    }
                    ++i;
                }
                this.closeAllOlder();
                if (monitor != null) {
                    monitor.done();
                }
                ContextServiceHolder.get().postEvent("info/elexis/model/reload", ILaborLeistung.class);
                if (newVersion != null) {
                    VersionUtil.setCurrentVersion(newVersion);
                }
                return Status.OK_STATUS;
            }
        }
        return new Status(4, "ch.elexis.labotarif.ch2009", "could not load file");
    }

    private TimeTool getValidFromVersion(Integer newVersion) {
        String intString = Integer.toString(newVersion);
        if (intString.length() != 6) {
            throw new IllegalStateException("Version " + String.valueOf(newVersion) + " can not be parsed to valid date.");
        }
        String year = intString.substring(0, 2);
        String month = intString.substring(2, 4);
        String day = intString.substring(4, 6);
        TimeTool ret = new TimeTool();
        ret.set(1, Integer.parseInt(year) + 2000);
        ret.set(2, Integer.parseInt(month) - 1);
        ret.set(5, Integer.parseInt(day));
        return ret;
    }

    private void updateOrCreateFromImportedValues() {
        INamedQuery query = ModelServiceHolder.get().getNamedQuery(ILaborLeistung.class, new String[]{"code"});
        List entries = query.executeWithParameters(query.getParameterMap(new Object[]{"code", this.importedValues.get(FLD_CODE)}));
        ArrayList<ILaborLeistung> openEntries = new ArrayList<ILaborLeistung>();
        for (ILaborLeistung existing : entries) {
            LocalDate validTo = existing.getValidTo();
            if (validTo != null) continue;
            openEntries.add(existing);
        }
        if (openEntries.isEmpty()) {
            this.createWithValues(this.importedValues);
        } else {
            for (ILaborLeistung openEntry : openEntries) {
                if (openEntry.getValidFrom().equals(this.validFrom)) {
                    this.updateWithValues(openEntry, this.importedValues);
                    continue;
                }
                ModelServiceHolder.get().setEntityProperty(FLD_GUELTIGBIS, (Object)this.validFrom.minusDays(1L), (Identifiable)openEntry);
                this.createWithValues(this.importedValues);
            }
        }
    }

    private void updateWithValues(ILaborLeistung existing, HashMap<String, String> values) {
        IModelService modelService = ModelServiceHolder.get();
        modelService.setEntityProperty(FLD_CHAPTER, (Object)this.concatChapter(existing, values.get(FLD_CHAPTER)), (Identifiable)existing);
        modelService.setEntityProperty(FLD_CODE, (Object)values.get(FLD_CODE), (Identifiable)existing);
        modelService.setEntityProperty(FLD_TP, (Object)Double.valueOf(values.get(FLD_TP)), (Identifiable)existing);
        modelService.setEntityProperty(FLD_NAME, (Object)values.get(FLD_NAME), (Identifiable)existing);
        modelService.setEntityProperty(FLD_LIMITATIO, (Object)values.get(FLD_LIMITATIO), (Identifiable)existing);
        modelService.setEntityProperty(FLD_FACHBEREICH, (Object)Fachspec.getFachspec(this.specs, this.row), (Identifiable)existing);
        modelService.save((Identifiable)existing);
    }

    private ILaborLeistung createWithValues(HashMap<String, String> values) {
        IModelService modelService = ModelServiceHolder.get();
        ILaborLeistung created = (ILaborLeistung)modelService.create(ILaborLeistung.class);
        modelService.setEntityProperty(FLD_CHAPTER, (Object)values.get(FLD_CHAPTER), (Identifiable)created);
        modelService.setEntityProperty(FLD_CODE, (Object)values.get(FLD_CODE), (Identifiable)created);
        modelService.setEntityProperty(FLD_TP, (Object)Double.valueOf(values.get(FLD_TP)), (Identifiable)created);
        modelService.setEntityProperty(FLD_NAME, (Object)values.get(FLD_NAME), (Identifiable)created);
        modelService.setEntityProperty(FLD_LIMITATIO, (Object)values.get(FLD_LIMITATIO), (Identifiable)created);
        modelService.setEntityProperty(FLD_FACHBEREICH, (Object)Fachspec.getFachspec(this.specs, this.row), (Identifiable)created);
        modelService.setEntityProperty(FLD_GUELTIGVON, (Object)this.validFrom, (Identifiable)created);
        modelService.save((Identifiable)created);
        return created;
    }

    private String concatChapter(ILaborLeistung existing, String chapter) {
        String existingChapter = existing.getChapter();
        if (existingChapter != null && !existingChapter.isEmpty()) {
            return this.chaptersMakeUnique(existingChapter + ", " + chapter);
        }
        return this.chaptersMakeUnique(chapter);
    }

    private String chaptersMakeUnique(String chapters) {
        String[] parts = chapters.split(", ");
        if (parts != null && parts.length > 1) {
            StringBuilder sb = new StringBuilder();
            HashSet<String> set = new HashSet<String>();
            set.addAll(Arrays.asList(parts));
            Object[] array = set.toArray(new String[set.size()]);
            Arrays.sort(array);
            Object[] objectArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object string = objectArray[n2];
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append((String)string);
                ++n2;
            }
            return sb.toString();
        }
        return chapters;
    }

    private void fillImportedValues2012(String[] line) {
        this.importedValues.clear();
        this.importedValues.put(FLD_CHAPTER, StringTool.getSafe((String[])line, (int)0));
        String code = this.convertCodeString(StringTool.getSafe((String[])line, (int)2));
        this.importedValues.put(FLD_CODE, code);
        this.importedValues.put(FLD_TP, this.convertLocalizedNumericString(StringTool.getSafe((String[])line, (int)3)).toString());
        this.importedValues.put(FLD_NAME, StringTool.limitLength((String)StringTool.getSafe((String[])line, (int)4), (int)254));
        this.importedValues.put(FLD_LIMITATIO, StringTool.getSafe((String[])line, (int)5));
        this.importedValues.put(FLD_FACHBEREICH, StringTool.getSafe((String[])line, (int)7));
    }

    private void fillImportedValues2011(String[] line) {
        this.importedValues.clear();
        this.importedValues.put(FLD_CHAPTER, StringTool.getSafe((String[])line, (int)0));
        String code = this.convertCodeString(StringTool.getSafe((String[])line, (int)2));
        this.importedValues.put(FLD_CODE, code);
        this.importedValues.put(FLD_TP, this.convertLocalizedNumericString(StringTool.getSafe((String[])line, (int)3)).toString());
        this.importedValues.put(FLD_NAME, StringTool.limitLength((String)StringTool.getSafe((String[])line, (int)4), (int)254));
        this.importedValues.put(FLD_LIMITATIO, StringTool.getSafe((String[])line, (int)5));
        this.importedValues.put(FLD_FACHBEREICH, StringTool.getSafe((String[])line, (int)6));
    }

    private void fillImportedValues2018(String[] line) {
        this.importedValues.clear();
        this.importedValues.put(FLD_CHAPTER, StringTool.getSafe((String[])line, (int)0));
        if (StringTool.getSafe((String[])line, (int)6).equals("1") || StringTool.getSafe((String[])line, (int)6).equalsIgnoreCase("true")) {
            this.importedValues.put(FLD_CHAPTER, StringTool.getSafe((String[])line, (int)0) + ", 5.1.2.2.1");
        }
        String code = this.convertCodeString(StringTool.getSafe((String[])line, (int)1));
        this.importedValues.put(FLD_CODE, code);
        this.importedValues.put(FLD_TP, this.convertLocalizedNumericString(StringTool.getSafe((String[])line, (int)2)).toString());
        this.importedValues.put(FLD_NAME, StringTool.limitLength((String)StringTool.getSafe((String[])line, (int)3), (int)254));
        this.importedValues.put(FLD_LIMITATIO, StringTool.getSafe((String[])line, (int)4));
        this.importedValues.put(FLD_FACHBEREICH, StringTool.getSafe((String[])line, (int)5));
    }

    private void closeAllOlder() {
        IModelService modelService = ModelServiceHolder.get();
        LocalDate defaultValidFrom = LocalDate.of(1970, 1, 1);
        List entries = modelService.getQuery(ILaborLeistung.class).execute();
        ArrayList<ILaborLeistung> oldEntriesToSave = new ArrayList<ILaborLeistung>();
        for (ILaborLeistung entry : entries) {
            if (entry.getValidFrom() == null) {
                modelService.setEntityProperty(FLD_GUELTIGVON, (Object)defaultValidFrom, (Identifiable)entry);
                modelService.setEntityProperty(FLD_GUELTIGBIS, (Object)this.validFrom.minusDays(1L), (Identifiable)entry);
                continue;
            }
            if (entry.getValidTo() != null || entry.getValidFrom().equals(this.validFrom)) continue;
            modelService.setEntityProperty(FLD_GUELTIGBIS, (Object)this.validFrom.minusDays(1L), (Identifiable)entry);
            oldEntriesToSave.add(entry);
        }
        modelService.save(oldEntriesToSave);
    }

    private String convertCodeString(String code) {
        String[] parts = code.split("[\\.,']");
        StringBuilder sb = new StringBuilder();
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            sb.append(part);
            if (sb.length() == 4) {
                sb.append(".");
            }
            ++n2;
        }
        if (sb.length() == 5) {
            sb.append("00");
        } else if (sb.length() == 6) {
            sb.append("0");
        }
        return sb.toString();
    }

    private String convertLocalizedNumericString(String localized) {
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance();
        Number number = new Integer(0);
        try {
            number = df.parse(localized);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (number.doubleValue() % 1.0 > 0.0) {
            return Double.toString(number.doubleValue());
        }
        return Integer.toString(number.intValue());
    }

    private int getFormatYear(String[] line) {
        String fach2011 = StringTool.getSafe((String[])line, (int)6);
        String fach2012 = StringTool.getSafe((String[])line, (int)7);
        String code2018 = StringTool.getSafe((String[])line, (int)1);
        if (fach2012.equals("") && !fach2011.equals("")) {
            if (this.isCode(code2018)) {
                return 2018;
            }
            return 2011;
        }
        if (fach2011.equals("") && !fach2012.equals("")) {
            return 2012;
        }
        return -1;
    }

    private boolean isCode(String code2018) {
        Integer value = Integer.valueOf(code2018 = code2018.replaceAll("[\\.,']", ""));
        return value >= 1000;
    }

    public int getCurrentVersion() {
        return VersionUtil.getCurrentVersion();
    }
}

