/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.labortarif.model;

import ch.elexis.base.ch.labortarif.ILaborLeistung;
import ch.elexis.base.ch.labortarif.model.LaborLeistungOptifier;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Labor2009Tarif;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.model.IBillableOptifier;
import ch.elexis.core.model.IBillableVerifier;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.billable.DefaultVerifier;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.XidServiceHolder;
import ch.elexis.core.types.VatInfo;
import ch.rgw.tools.StringTool;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;

public class LaborLeistung
extends AbstractIdDeleteModelAdapter<Labor2009Tarif>
implements Identifiable,
ILaborLeistung {
    public static final String STS_CLASS = "ch.elexis.labortarif2009.data.Labor2009Tarif";
    private static IBillableOptifier<ILaborLeistung> optifier;
    private IBillableVerifier verifier = new DefaultVerifier();

    public LaborLeistung(Labor2009Tarif entity) {
        super((EntityWithId)entity);
    }

    public IBillableVerifier getVerifier() {
        return this.verifier;
    }

    public String getCodeSystemName() {
        return "EAL 2009";
    }

    public String getCodeSystemCode() {
        return "317";
    }

    public VatInfo getVatInfo() {
        return VatInfo.VAT_NONE;
    }

    public String getCode() {
        return ((Labor2009Tarif)this.getEntity()).getCode();
    }

    public void setCode(String value) {
        ((Labor2009Tarif)this.getEntity()).setCode(value);
    }

    public String getText() {
        return StringTool.getFirstLine((String)((Labor2009Tarif)this.getEntity()).getName(), (int)80);
    }

    public void setText(String value) {
        ((Labor2009Tarif)this.getEntity()).setName(value);
    }

    public synchronized IBillableOptifier<ILaborLeistung> getOptifier() {
        if (optifier == null) {
            optifier = new LaborLeistungOptifier(CoreModelServiceHolder.get(), ContextServiceHolder.get());
        }
        return optifier;
    }

    @Override
    public int getPoints() {
        return (int)Math.round(((Labor2009Tarif)this.getEntity()).getTp() * 100.0);
    }

    @Override
    public LocalDate getValidFrom() {
        return ((Labor2009Tarif)this.getEntity()).getGueltigVon();
    }

    @Override
    public LocalDate getValidTo() {
        return ((Labor2009Tarif)this.getEntity()).getGueltigBis();
    }

    @Override
    public boolean isValidOn(LocalDate date) {
        boolean validFrom;
        boolean bl = validFrom = this.getValidFrom().isBefore(date) || this.getValidFrom().isEqual(date);
        if (validFrom && this.getValidTo() != null) {
            return this.getValidTo().isAfter(date) || this.getValidTo().isEqual(date);
        }
        return validFrom;
    }

    @Override
    public String getChapter() {
        return ((Labor2009Tarif)this.getEntity()).getChapter();
    }

    @Override
    public String getSpeciality() {
        return ((Labor2009Tarif)this.getEntity()).getFachbereich();
    }

    public String getLabel() {
        String text = StringTool.getFirstLine((String)this.getText(), (int)80);
        if (StringUtils.isNotBlank((CharSequence)this.getCode())) {
            StringBuilder sb = new StringBuilder(this.getCode()).append(" ").append(text).append(" (").append(this.getSpeciality()).append(")");
            DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
            if (this.getValidFrom() != null) {
                sb.append(" (").append(this.getValidFrom().format(dateFormatter));
                if (this.getValidTo() != null) {
                    sb.append("-").append(this.getValidTo().format(dateFormatter)).append(")");
                } else {
                    sb.append("-").append(" ").append(")");
                }
            }
            return sb.toString();
        }
        return "?";
    }

    @Override
    public String getLimitation() {
        return ((Labor2009Tarif)this.getEntity()).getLimitatio();
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return XidServiceHolder.get().addXid((Identifiable)this, domain, id, updateIfExists);
    }

    public IXid getXid(String domain) {
        return XidServiceHolder.get().getXid((Identifiable)this, domain);
    }
}

