/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.labortarif.model;

import ch.elexis.base.ch.labortarif.ILaborLeistung;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBillableVerifier;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IEncounter;
import ch.rgw.tools.Result;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class LaborLeistungVerifier
implements IBillableVerifier {
    public Result<IBillable> verifyAdd(IBillable billable, IEncounter encounter, double amount) {
        if (billable instanceof ILaborLeistung) {
            ILaborLeistung laborLeistung = (ILaborLeistung)billable;
            LocalDate date = encounter.getDate();
            if (laborLeistung.isValidOn(date)) {
                return Result.OK();
            }
            DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
            return new Result(Result.SEVERITY.ERROR, 2, laborLeistung.getCode() + " (" + laborLeistung.getValidFrom().format(dateFormatter) + "-" + laborLeistung.getValidTo().format(dateFormatter) + ") G\u00fcltigkeit beinhaltet nicht das Konsultationsdatum " + date.format(dateFormatter), (Object)billable, false);
        }
        return new Result(Result.SEVERITY.ERROR, 2, "Verrechneter code [" + String.valueOf(billable) + "] ist keine Laborleistung", (Object)billable, true);
    }

    public Result<IBilled> verify(IEncounter encounter) {
        return Result.OK();
    }
}

