/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.ebanking.esr;

import ch.elexis.base.ch.ebanking.esr.Messages;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.IAccount;
import ch.elexis.core.services.holder.AccountServiceHolder;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.text.TextContainer;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Kontakt;
import ch.rgw.tools.StringTool;
import java.util.Collection;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESR {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String ESR_NORMAL_FONT_NAME = "esr/normalfontname";
    public static final String ESR_NORMAL_FONT_SIZE = "esr/normalfontsize";
    public static final String ESR_OCR_FONT_NAME = "esr/ocrfontname";
    public static final String ESR_OCR_FONT_SIZE = "esr/ocrfontsize";
    public static final String ESR_OCR_FONT_WEIGHT = "esr/ocrfontweight";
    public static final String ESR_NORMAL_FONT_NAME_DEFAULT = "OCR-B";
    public static final int ESR_NORMAL_FONT_SIZE_DEFAULT = 9;
    public static final String ESR_OCR_FONT_NAME_DEFAULT = "OCR-B-10 BT";
    public static final int ESR_OCR_FONT_SIZE_DEFAULT = 12;
    public static final int ESR_OCR_FONT_WEIGHT_DEFAULT = 128;
    public static final String ESR_PRINTER_CORRECTION_X = "esr/printer_correction_x";
    public static final String ESR_PRINTER_CORRECTION_Y = "esr/printer_correction_y";
    public static final String ESR_PRINTER_BASE_OFFSET_X = "esr/printer_base_x";
    public static final String ESR_PRINTER_BASE_OFFSET_Y = "esr/printer_base_y";
    public static final int ESR_PRINTER_CORRECTION_X_DEFAULT = 0;
    public static final int ESR_PRINTER_CORRECTION_Y_DEFAULT = 0;
    public static final int ESR_PRINTER_BASE_OFFSET_X_DEFAULT = 0;
    public static final int ESR_PRINTER_BASE_OFFSET_Y_DEFAULT = 0;
    public static final int ESR16 = 16;
    public static final int ESR27 = 27;
    private String tn;
    private String id;
    private String userdata;
    private int reflen;
    private static final int[][] checksum;
    private static IAccount esrAccount;

    static {
        int[][] nArrayArray = new int[10][];
        int[] nArray = new int[11];
        nArray[1] = 9;
        nArray[2] = 4;
        nArray[3] = 6;
        nArray[4] = 8;
        nArray[5] = 2;
        nArray[6] = 7;
        nArray[7] = 1;
        nArray[8] = 3;
        nArray[9] = 5;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[11];
        nArray2[0] = 9;
        nArray2[1] = 4;
        nArray2[2] = 6;
        nArray2[3] = 8;
        nArray2[4] = 2;
        nArray2[5] = 7;
        nArray2[6] = 1;
        nArray2[7] = 3;
        nArray2[8] = 5;
        nArray2[10] = 9;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[11];
        nArray3[0] = 4;
        nArray3[1] = 6;
        nArray3[2] = 8;
        nArray3[3] = 2;
        nArray3[4] = 7;
        nArray3[5] = 1;
        nArray3[6] = 3;
        nArray3[7] = 5;
        nArray3[9] = 9;
        nArray3[10] = 8;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[11];
        nArray4[0] = 6;
        nArray4[1] = 8;
        nArray4[2] = 2;
        nArray4[3] = 7;
        nArray4[4] = 1;
        nArray4[5] = 3;
        nArray4[6] = 5;
        nArray4[8] = 9;
        nArray4[9] = 4;
        nArray4[10] = 7;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[11];
        nArray5[0] = 8;
        nArray5[1] = 2;
        nArray5[2] = 7;
        nArray5[3] = 1;
        nArray5[4] = 3;
        nArray5[5] = 5;
        nArray5[7] = 9;
        nArray5[8] = 4;
        nArray5[9] = 6;
        nArray5[10] = 6;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[11];
        nArray6[0] = 2;
        nArray6[1] = 7;
        nArray6[2] = 1;
        nArray6[3] = 3;
        nArray6[4] = 5;
        nArray6[6] = 9;
        nArray6[7] = 4;
        nArray6[8] = 6;
        nArray6[9] = 8;
        nArray6[10] = 5;
        nArrayArray[5] = nArray6;
        int[] nArray7 = new int[11];
        nArray7[0] = 7;
        nArray7[1] = 1;
        nArray7[2] = 3;
        nArray7[3] = 5;
        nArray7[5] = 9;
        nArray7[6] = 4;
        nArray7[7] = 6;
        nArray7[8] = 8;
        nArray7[9] = 2;
        nArray7[10] = 4;
        nArrayArray[6] = nArray7;
        int[] nArray8 = new int[11];
        nArray8[0] = 1;
        nArray8[1] = 3;
        nArray8[2] = 5;
        nArray8[4] = 9;
        nArray8[5] = 4;
        nArray8[6] = 6;
        nArray8[7] = 8;
        nArray8[8] = 2;
        nArray8[9] = 7;
        nArray8[10] = 3;
        nArrayArray[7] = nArray8;
        int[] nArray9 = new int[11];
        nArray9[0] = 3;
        nArray9[1] = 5;
        nArray9[3] = 9;
        nArray9[4] = 4;
        nArray9[5] = 6;
        nArray9[6] = 8;
        nArray9[7] = 2;
        nArray9[8] = 7;
        nArray9[9] = 1;
        nArray9[10] = 2;
        nArrayArray[8] = nArray9;
        int[] nArray10 = new int[11];
        nArray10[0] = 5;
        nArray10[2] = 9;
        nArray10[3] = 4;
        nArray10[4] = 6;
        nArray10[5] = 8;
        nArray10[6] = 2;
        nArray10[7] = 7;
        nArray10[8] = 1;
        nArray10[9] = 3;
        nArray10[10] = 1;
        nArrayArray[9] = nArray10;
        checksum = nArrayArray;
    }

    public ESR(String ESR_tn, String ESR_subid, String usr, int l) {
        this.tn = ESR_tn;
        this.id = ESR_subid == null ? "" : ESR_subid;
        this.reflen = l - 1;
        this.userdata = usr;
    }

    public String createCodeline(String amount, String tcCode) {
        if (Integer.parseInt(amount) < 0) {
            amount = "0";
        }
        StringBuilder cl = new StringBuilder();
        if (tcCode == null) {
            tcCode = "01";
        }
        String betrag = this.wrap(tcCode + StringTool.pad((int)1, (char)'0', (String)amount, (int)10));
        cl.append(betrag);
        cl.append(">");
        cl.append(this.makeRefNr(false));
        cl.append("+ ");
        cl.append(this.makeParticipantNumber(false)).append(">");
        return cl.toString();
    }

    public String makeRefNr(boolean withSpaces) {
        StringBuilder ret = new StringBuilder();
        int il = this.id.length();
        int ul = this.userdata.length();
        int space = this.reflen - ul - il;
        if (space < 0) {
            this.userdata = this.userdata.substring(space * -1);
            SWTHelper.showError((String)Messages.ESR_esr_invalid, (String)Messages.ESR_warning_esr_not_correct);
            ret.append(this.id).append(this.userdata);
        } else {
            ret.append(this.id).append(StringTool.filler((String)"0", (int)space)).append(this.userdata);
        }
        String refnr = this.wrap(ret.toString());
        if (!withSpaces) {
            return refnr;
        }
        if (refnr.length() == 16) {
            return refnr.substring(0, 2) + " " + refnr.substring(3, 6) + " " + refnr.substring(7);
        }
        if (refnr.length() == 27) {
            String g1 = refnr.substring(0, 2);
            String g2 = refnr.substring(2, 7);
            String g3 = refnr.substring(7, 12);
            String g4 = refnr.substring(12, 17);
            String g5 = refnr.substring(17, 22);
            String g6 = refnr.substring(22);
            return g1 + " " + g2 + " " + g3 + " " + g4 + " " + g5 + " " + g6;
        }
        return "** ERROR **";
    }

    public String makeParticipantNumber(boolean withSeparators) {
        if (withSeparators) {
            return this.tn;
        }
        String[] ptn = this.tn.split("\\s*-\\s*");
        if (ptn.length != 3) {
            this.log.error(Messages.ESR_bad_user_defin + this.tn);
            return Messages.ESR_errorMark;
        }
        return ptn[0] + StringTool.pad((int)1, (char)'0', (String)ptn[1], (int)6) + ptn[2];
    }

    public String wrap(String number) {
        int row = 0;
        String nr = number.replaceAll("[^0-9]", "");
        int i = 0;
        while (i < nr.length()) {
            int col = Integer.parseInt(nr.substring(i, i + 1));
            row = checksum[row][col];
            ++i;
        }
        return number + Integer.toString(checksum[row][10]);
    }

    public int getESRLineX() {
        int printerCorrectionX = CoreHub.localCfg.get(ESR_PRINTER_CORRECTION_X, 0);
        return 59 + printerCorrectionX;
    }

    public int getESRLineY() {
        int printerCorrectionY = CoreHub.localCfg.get(ESR_PRINTER_CORRECTION_Y, 0);
        return 277 + printerCorrectionY;
    }

    public int getESRLineWidth() {
        return 140;
    }

    public int getESRLineHeight() {
        return 4;
    }

    public boolean printBESR(Kontakt bank, Kontakt schuldner, Kontakt empfaenger, String betragInRappen, TextContainer text) {
        int yBase = 192;
        int xBase = 0;
        int wFr = 40;
        int hFr = 6;
        int wRp = 10;
        int wRef = 81;
        int hRef = 6;
        int xRef = 63;
        int yRef = 33;
        int xGiro = 60;
        int hAdr = 10;
        int hBeg = 20;
        int xKonto = 22;
        int wKonto = 30;
        int yKonto = 42;
        int hKonto = 5;
        int yGarant1 = 60;
        int yGarant2 = 50;
        int wAdresse = 55;
        int manualYOffsetESR = CoreHub.localCfg.get(ESR_PRINTER_BASE_OFFSET_Y, 0);
        int manualXOffsetESR = CoreHub.localCfg.get(ESR_PRINTER_BASE_OFFSET_X, 0);
        ITextPlugin p = text.getPlugin();
        String fontName = CoreHub.localCfg.get(ESR_NORMAL_FONT_NAME, ESR_NORMAL_FONT_NAME_DEFAULT);
        int fontSize = CoreHub.localCfg.get(ESR_NORMAL_FONT_SIZE, 9);
        p.setFont(fontName, 0, (float)fontSize);
        xBase += manualXOffsetESR;
        yBase += manualYOffsetESR;
        xGiro += manualXOffsetESR;
        if (bank != null && bank.isValid()) {
            StringBuilder badr = new StringBuilder();
            badr.append(bank.get("Bezeichnung1")).append(" ").append(bank.get("Bezeichnung2")).append("\n").append(bank.get("Plz")).append(" ").append(bank.get("Ort"));
            p.insertTextAt(xBase, yBase + 8, wAdresse, hAdr - 2, badr.toString(), 16384);
            p.insertTextAt(xGiro, yBase + 8, wAdresse, hAdr - 2, badr.toString(), 16384);
            p.insertTextAt(xBase, yBase + 20, wAdresse, hBeg - 1, empfaenger.getPostAnschrift(true), 16384);
            p.insertTextAt(xGiro, yBase + 20, wAdresse, hBeg - 1, empfaenger.getPostAnschrift(true), 16384);
        } else {
            int height = hAdr + 2 + hBeg;
            p.insertTextAt(xBase, yBase + 8, wAdresse, height, empfaenger.getPostAnschrift(true), 16384);
            p.insertTextAt(xGiro, yBase + 8, wAdresse, height, empfaenger.getPostAnschrift(true), 16384);
        }
        int betrag = Integer.parseInt(betragInRappen);
        int fr = betrag / 100;
        int rp = betrag - 100 * fr;
        String Franken = Integer.toString(fr);
        String Rappen = StringTool.pad((int)1, (char)'0', (String)Integer.toString(rp), (int)2);
        p.insertTextAt(xBase + 3, yBase + 50, wFr, hFr, Franken, 0x1000000);
        p.insertTextAt(xBase + 45, yBase + 50, wRp, hFr, Rappen, 16384);
        p.insertTextAt(xGiro + xRef, yBase + yRef, wRef, hRef, this.makeRefNr(true), 0x1000000);
        String konto = this.makeParticipantNumber(true);
        p.insertTextAt(xBase + xKonto, yBase + yKonto, wKonto, hKonto, konto, 16384);
        p.insertTextAt(xGiro + xKonto, yBase + yKonto, wKonto, hKonto, konto, 16384);
        String refNr = this.makeRefNr(false).replaceFirst("^0+", "");
        String abs1 = refNr + "\n" + schuldner.getPostAnschrift(true);
        p.insertTextAt(xBase, yBase + yGarant1, wAdresse, 25, abs1, 16384);
        p.insertTextAt(xGiro + xRef, yBase + yGarant2, wAdresse, 25, schuldner.getPostAnschrift(true), 16384);
        p.insertTextAt(xGiro + 5, yBase + 50, wFr, hFr, Franken, 0x1000000);
        p.insertTextAt(xGiro + 45, yBase + 50, wRp, hFr, Rappen, 16384);
        this.printESRCodeLine(p, betragInRappen, null);
        return true;
    }

    public void printESRCodeLine(ITextPlugin p, String betragInRappen, String tcCode) {
        String besr = this.createCodeline(betragInRappen, tcCode);
        String fontname = CoreHub.localCfg.get(ESR_OCR_FONT_NAME, ESR_OCR_FONT_NAME_DEFAULT);
        int fontscale = CoreHub.localCfg.get(ESR_OCR_FONT_SIZE, 12);
        int fontweight = CoreHub.localCfg.get(ESR_OCR_FONT_WEIGHT, 128);
        p.setFont(fontname, fontweight, (float)fontscale);
        p.insertTextAt(this.getESRLineX(), this.getESRLineY(), this.getESRLineWidth(), this.getESRLineHeight(), besr, 0x1000000);
    }

    public static IAccount getAccount() {
        if (esrAccount == null) {
            HashMap accountsMap = AccountServiceHolder.get().getAccounts();
            Collection accounts = accountsMap.values();
            for (IAccount account : accounts) {
                if (!account.getName().contains("ESR")) continue;
                esrAccount = account;
                break;
            }
        }
        return esrAccount;
    }
}

