/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.ebanking.print;

import ch.elexis.base.ch.ebanking.print.ESRFileJournalRecord;
import ch.elexis.core.model.IUser;
import ch.elexis.core.services.holder.ContextServiceHolder;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@XmlRootElement
public class ESRFileJournalLetter {
    @XmlElement
    private String user;
    @XmlElement
    private String date;
    @XmlElementWrapper(name="records")
    @XmlElement(name="record")
    private List<ESRFileJournalRecord> records;

    public ESRFileJournalLetter() {
    }

    public ESRFileJournalLetter(List<?> records) {
        Optional activeUser = ContextServiceHolder.get().getActiveUser();
        this.user = activeUser.isPresent() ? ((IUser)activeUser.get()).getLabel() : "?";
        this.date = LocalDate.now().format(DateTimeFormatter.ofPattern("dd.MM.yyyy"));
        this.records = records.stream().map(ol -> new ESRFileJournalRecord(Arrays.asList((Object[])ol))).collect(Collectors.toList());
    }
}

