/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.ebanking.esr;

import ch.elexis.base.ch.ebanking.esr.ESRRecord;
import ch.elexis.base.ch.ebanking.esr.Messages;
import ch.elexis.data.Query;
import ch.elexis.ebanking.parser.Camt054Parser;
import ch.elexis.ebanking.parser.Camt054Record;
import ch.rgw.io.FileTool;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Result;
import ch.rgw.tools.StringTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class ESRFile {
    List<ESRRecord> list = new ArrayList<ESRRecord>();
    String name;
    String hash;

    /*
     * Loose catch block
     */
    public Result<List<ESRRecord>> read(File file, IProgressMonitor monitor) {
        if (!file.exists()) {
            return new Result(Result.SEVERITY.ERROR, 1, Messages.ESRFile_esrfile_not_founde, null, true);
        }
        if (!file.canRead()) {
            return new Result(Result.SEVERITY.ERROR, 2, Messages.ESRFile_cannot_read_esr, null, true);
        }
        byte[] md5 = FileTool.checksum((File)file);
        this.name = file.getName();
        this.hash = md5 != null ? StringTool.enPrintableStrict((byte[])md5) : this.name;
        Query qesr = new Query(ESRRecord.class);
        qesr.add("File", "=", this.hash);
        List list = qesr.execute();
        if (list.size() > 0) {
            return new Result(Result.SEVERITY.ERROR, 4, Messages.ESRFile_file_already_read, null, true);
        }
        String fileName = file.getName();
        if ("xml".equalsIgnoreCase(FilenameUtils.getExtension((String)fileName))) {
            try {
                Throwable throwable = null;
                Object var8_13 = null;
                try (FileInputStream inputStream = new FileInputStream(file);){
                    Camt054Parser camt054Parser = new Camt054Parser();
                    List inputs = camt054Parser.parseRecords((InputStream)inputStream);
                    for (Camt054Record camt054Record : inputs) {
                        ESRRecord esr = new ESRRecord(this.hash, camt054Record);
                        list.add(esr);
                        monitor.worked(1);
                    }
                    return new Result(Result.SEVERITY.OK, 0, "OK", (Object)list, false);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception ex2222) {
                ExHandler.handle((Throwable)ex2222);
                return new Result(Result.SEVERITY.ERROR, 3, Messages.ESRFile_ExceptionParsing, (Object)list, true);
            }
        }
        try {
            Throwable ex2222 = null;
            Object var8_15 = null;
            try {
                Result result;
                BufferedReader br;
                InputStreamReader ir;
                block38: {
                    block37: {
                        String in;
                        ir = new InputStreamReader(new FileInputStream(file));
                        br = new BufferedReader(ir);
                        LinkedList<String> records = new LinkedList<String>();
                        while ((in = br.readLine()) != null) {
                            int i = 0;
                            while (i < in.length()) {
                                int eidx = i + 125;
                                if (eidx >= in.length()) {
                                    eidx = in.length() - 1;
                                }
                                records.add(in.substring(i, eidx));
                                i += 128;
                            }
                        }
                        for (String s : records) {
                            ESRRecord esr = new ESRRecord(this.hash, s);
                            list.add(esr);
                            monitor.worked(1);
                        }
                        result = new Result(Result.SEVERITY.OK, 0, "OK", (Object)list, false);
                        if (br == null) break block37;
                        br.close();
                    }
                    if (ir == null) break block38;
                    ir.close();
                }
                return result;
                {
                    catch (Throwable ex2222) {
                        try {
                            if (br != null) {
                                br.close();
                            }
                            throw ex2222;
                        }
                        catch (Throwable throwable) {
                            if (ex2222 == null) {
                                ex2222 = throwable;
                            } else if (ex2222 != throwable) {
                                ex2222.addSuppressed(throwable);
                            }
                            if (ir != null) {
                                ir.close();
                            }
                            throw ex2222;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                if (ex2222 == null) {
                    ex2222 = throwable;
                } else if (ex2222 != throwable) {
                    ex2222.addSuppressed(throwable);
                }
                throw ex2222;
            }
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return new Result(Result.SEVERITY.ERROR, 3, Messages.ESRFile_ExceptionParsing, (Object)list, true);
        }
    }

    public List<ESRRecord> getLastResult() {
        return this.list;
    }

    public String getFilename() {
        return this.name;
    }
}

