/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.ebanking.command;

import ch.elexis.base.ch.ebanking.esr.ESRRecordDialog;
import ch.elexis.base.ch.ebanking.model.IEsrRecord;
import ch.elexis.base.ch.ebanking.model.service.holder.ModelServiceHolder;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.rgw.tools.TimeTool;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Display;

public class OpenESRWithinvoiceIdHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String invoiceId = event.getParameter("ch.elexis.ebanking_ch.command.openESR.InvoiceId");
        String paymentDate = event.getParameter("ch.elexis.ebanking_ch.command.openESR.PaymentDate");
        if (StringUtils.isNotBlank((CharSequence)invoiceId) && StringUtils.isNotBlank((CharSequence)paymentDate)) {
            TimeTool paymentDateTimeTool = new TimeTool(paymentDate);
            IQuery esrQuery = ModelServiceHolder.get().getQuery(IEsrRecord.class);
            esrQuery.and("rechnung", IQuery.COMPARATOR.EQUALS, CoreModelServiceHolder.get().load(invoiceId, IInvoice.class).get());
            esrQuery.and("verarbeitet", IQuery.COMPARATOR.EQUALS, (Object)paymentDateTimeTool.toLocalDate());
            List esrRecords = esrQuery.execute();
            if (!esrRecords.isEmpty()) {
                for (IEsrRecord esrRecord : esrRecords) {
                    ESRRecordDialog erd = new ESRRecordDialog(Display.getDefault().getActiveShell(), esrRecord);
                    erd.open();
                }
            }
        }
        return null;
    }
}

