/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.ebanking;

import ch.elexis.base.ch.ebanking.esr.Messages;
import ch.elexis.base.ch.ebanking.model.IEsrRecord;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.esr.ESRRejectCode;
import ch.elexis.core.ui.UiDesk;
import java.text.DecimalFormat;
import java.time.format.DateTimeFormatter;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class ESRLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    DecimalFormat df = new DecimalFormat("###0.00");
    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        IEsrRecord rec = (IEsrRecord)element;
        switch (columnIndex) {
            case 0: {
                text = this.formatter.format(rec.getDate());
                break;
            }
            case 1: {
                IInvoice rn = rec.getInvoice();
                if (rn == null) break;
                text = rn.getNumber();
                break;
            }
            case 2: {
                text = rec.getAmount().getAmountAsString();
                break;
            }
            case 3: {
                text = this.formatter.format(rec.getImportDate());
                break;
            }
            case 4: {
                text = this.formatter.format(rec.getProcessingDate());
                break;
            }
            case 5: {
                text = this.formatter.format(rec.getValutaDate());
                break;
            }
            case 6: {
                text = rec.getPatient() != null ? rec.getPatient().getLabel() : "";
                break;
            }
            case 7: {
                if (!rec.hasBookedDate()) {
                    text = Messages.ESRView2_notbooked;
                    break;
                }
                text = this.formatter.format(rec.getBookedDate());
                break;
            }
            case 8: {
                text = rec.getFile();
            }
        }
        return text;
    }

    public Color getForeground(Object element, int columnIndex) {
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        IEsrRecord rec = (IEsrRecord)element;
        if (rec.getRejectCode() == ESRRejectCode.OK) {
            if (!rec.hasBookedDate()) {
                return UiDesk.getColor((String)"grau");
            }
            return UiDesk.getColor((String)"weiss");
        }
        return UiDesk.getColor((String)"rot");
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }
}

