/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.ebanking.esr;

import ch.elexis.base.ch.ebanking.esr.ESR;
import ch.elexis.base.ch.ebanking.esr.Messages;
import ch.elexis.base.ch.ebanking.model.IEsrRecord;
import ch.elexis.base.ch.ebanking.model.service.holder.ModelServiceHolder;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IPayment;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.InvoiceServiceHolder;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.icons.ImageSize;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.LabeledInputField;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Fall;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnung;
import ch.rgw.tools.Money;
import java.text.MessageFormat;
import java.time.LocalDate;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ESRRecordDialog
extends TitleAreaDialog {
    private IEsrRecord rec;
    private boolean bBooked;
    private Button bKeep;
    private Button bBook;
    private Button bUnbook;
    private Button bDelete;
    private Label lFile;
    private LabeledInputField.AutoForm af;
    private LabeledInputField.InputData[] fields = new LabeledInputField.InputData[]{new LabeledInputField.InputData(Messages.ESRRecordDialog_readInDate, "importDateString", LabeledInputField.InputData.Typ.DATE, null), new LabeledInputField.InputData(Messages.ESRRecordDialog_esrType, "code", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData(Messages.ESRRecordDialog_bookedDate, "processingDateString", LabeledInputField.InputData.Typ.DATE, null), new LabeledInputField.InputData(Messages.ESRRecordDialog_addedDate, "valutaDateString", LabeledInputField.InputData.Typ.DATE, null), new LabeledInputField.InputData(Messages.ESRRecordDialog_receivedDate, "dateString", LabeledInputField.InputData.Typ.DATE, null), new LabeledInputField.InputData(Messages.ESRRecordDialog_amount, "amount", LabeledInputField.InputData.Typ.CURRENCY, null), new LabeledInputField.InputData(Messages.ESRRecordDialog_billNr, "invoice", new LabeledInputField.IContentProvider(){

        public void displayContent(Object po, LabeledInputField.InputData ltf) {
            IInvoice rn = ESRRecordDialog.this.rec.getInvoice();
            if (rn == null) {
                ltf.setText("??");
            } else {
                ltf.setText(rn.getNumber());
            }
        }

        public void reloadContent(Object po, LabeledInputField.InputData ltf) {
            InputDialog id = new InputDialog(ESRRecordDialog.this.getShell(), Messages.ESRRecordDialog_changeBillNr, Messages.ESRRecordDialog_pleaseEnterNewBilNr, ltf.getText(), null);
            if (id.open() == 0) {
                String rnid = new Query(Rechnung.class).findSingle("RnNummer", "=", id.getValue());
                int err = 0;
                if (rnid != null) {
                    Rechnung r = Rechnung.load((String)rnid);
                    if (r.isAvailable()) {
                        Fall fall = r.getFall();
                        if (fall.isAvailable()) {
                            Patient pat = fall.getPatient();
                            Mandant mn = r.getMandant();
                            if (pat.isAvailable()) {
                                ESRRecordDialog.this.rec.setInvoice(r.toIInvoice());
                                ESRRecordDialog.this.rec.setPatient(pat.toIPatient());
                                if (mn != null && mn.isValid()) {
                                    ESRRecordDialog.this.rec.setMandator(mn.toIContact());
                                }
                                CoreModelServiceHolder.get().save((Identifiable)ESRRecordDialog.this.rec);
                                ESRRecordDialog.this.af.reload((Identifiable)ESRRecordDialog.this.rec);
                            } else {
                                err = 4;
                            }
                        } else {
                            err = 3;
                        }
                    } else {
                        err = 2;
                    }
                } else {
                    err = 1;
                }
                if (err != 0) {
                    SWTHelper.showError((String)Messages.ESRRecordDialog_billNotFound, (String)MessageFormat.format(Messages.ESRRecordDialog_noValidBillFound, id.getValue()));
                }
            }
        }
    }), new LabeledInputField.InputData(Messages.ESRRecordDialog_patient, "patient", new LabeledInputField.IContentProvider(){

        public void displayContent(Object po, LabeledInputField.InputData ltf) {
            ltf.setText(ESRRecordDialog.this.rec.getPatient() != null ? ESRRecordDialog.this.rec.getPatient().getLabel() : "");
        }

        public void reloadContent(Object po, LabeledInputField.InputData ltf) {
            KontaktSelektor ksl = new KontaktSelektor(ESRRecordDialog.this.getShell(), Patient.class, Messages.ESRRecordDialog_selectPatient, Messages.ESRRecordDialog_pleaseSelectPatient, Patient.DEFAULT_SORT);
            if (ksl.open() == 0) {
                Patient actPatient = (Patient)ksl.getSelection();
                ESRRecordDialog.this.rec.setPatient(actPatient.toIPatient());
                CoreModelServiceHolder.get().save((Identifiable)ESRRecordDialog.this.rec);
                ltf.setText(actPatient.getLabel());
            }
        }
    })};

    public ESRRecordDialog(Shell shell, IEsrRecord element) {
        super(shell);
        this.rec = element;
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        TableWrapLayout twl = new TableWrapLayout();
        ret.setLayout((Layout)twl);
        this.af = new LabeledInputField.AutoForm(ret, this.fields);
        this.af.setModelService(ModelServiceHolder.get());
        TableWrapData twd = new TableWrapData(256);
        twd.grabHorizontal = true;
        this.af.setLayoutData((Object)twd);
        this.lFile = new Label(ret, 0);
        this.lFile.setText(Messages.ESRRecordDialog_file + this.rec.getFile());
        TableWrapData tw3 = new TableWrapData();
        tw3.grabHorizontal = true;
        this.lFile.setLayoutData((Object)tw3);
        Composite cChoices = new Composite(ret, 2048);
        TableWrapData tw2 = new TableWrapData();
        tw2.grabHorizontal = true;
        cChoices.setLayoutData((Object)tw2);
        RowLayout rl = new RowLayout(512);
        rl.fill = true;
        cChoices.setLayout((Layout)rl);
        this.bKeep = new Button(cChoices, 16);
        this.bKeep.setText(Messages.ESRRecordDialog_dontchange);
        this.bBook = new Button(cChoices, 16);
        this.bBook.setText(Messages.ESRRecordDialog_bookRecord);
        this.bUnbook = new Button(cChoices, 16);
        this.bUnbook.setText(Messages.ESRRecordDialog_dontBookRecord);
        this.bDelete = new Button(cChoices, 16);
        this.bDelete.setText(Messages.ESRRecordDialog_deleteRecord);
        this.bBooked = !LocalDate.EPOCH.equals(this.rec.getBookedDate());
        this.bKeep.setSelection(true);
        this.af.reload((Identifiable)this.rec);
        ret.pack();
        return ret;
    }

    public void create() {
        super.create();
        this.setTitle(Messages.ESRRecordDialog_editRecord);
        this.setMessage(Messages.ESRRecordDialog_warningEditing);
        this.setTitleImage(Images.IMG_LOGO.getImage(ImageSize._75x66_TitleDialogIconSize));
        this.getShell().setText(Messages.ESRRecordDialog_detailsForESRRecord);
    }

    protected void okPressed() {
        if (this.bBook.getSelection()) {
            if (!this.bBooked) {
                Money zahlung = this.rec.getAmount();
                IInvoice rn = this.rec.getInvoice();
                IPayment zahlungsObj = InvoiceServiceHolder.get().addPayment(rn, zahlung, Messages.ESRRecordDialog_vESRForBill + rn.getNumber() + " / " + this.rec.getPatient().getCode());
                zahlungsObj.setDate(this.rec.getValutaDate());
                CoreModelServiceHolder.get().save((Identifiable)zahlungsObj);
                if (zahlungsObj != null && ESR.getAccount() != null) {
                    InvoiceServiceHolder.get().getAccountTransaction(zahlungsObj).ifPresent(transaction -> {
                        transaction.setAccount(ESR.getAccount());
                        CoreModelServiceHolder.get().save((Identifiable)transaction);
                    });
                }
                this.rec.setBookedDate(this.rec.getValutaDate());
                ModelServiceHolder.get().save((Identifiable)this.rec);
            }
        } else if (this.bUnbook.getSelection()) {
            if (this.bBooked) {
                Money zahlung = this.rec.getAmount();
                IInvoice rn = this.rec.getInvoice();
                IPayment zahlungsObj = InvoiceServiceHolder.get().addPayment(rn, zahlung.negate(), Messages.ESRRecordDialog_stornoESR + rn.getNumber() + " / " + this.rec.getPatient().getCode());
                if (zahlungsObj != null && ESR.getAccount() != null) {
                    InvoiceServiceHolder.get().getAccountTransaction(zahlungsObj).ifPresent(transaction -> {
                        transaction.setAccount(ESR.getAccount());
                        CoreModelServiceHolder.get().save((Identifiable)transaction);
                    });
                }
                this.rec.setBookedDate(null);
                ModelServiceHolder.get().save((Identifiable)this.rec);
            }
        } else if (this.bDelete.getSelection()) {
            ModelServiceHolder.get().delete((Deleteable)this.rec);
        }
        super.okPressed();
    }

    protected boolean isResizable() {
        return true;
    }
}

