/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.diagnosecodes.util;

import ch.elexis.base.ch.diagnosecodes.service.CodeElementServiceHolder;
import ch.elexis.core.model.IDiagnosis;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.util.IKonsMakro;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TIMakro
implements IKonsMakro {
    private static Logger logger = LoggerFactory.getLogger(TIMakro.class);

    public String executeMakro(String makro) {
        Optional encounter = ContextServiceHolder.get().getRootContext().getTyped(IEncounter.class);
        if (encounter.isPresent()) {
            try {
                Optional tiCode = CodeElementServiceHolder.get().loadFromString("TI-Code", makro, null);
                if (tiCode.isPresent()) {
                    ((IEncounter)encounter.get()).addDiagnosis((IDiagnosis)tiCode.get());
                    CoreModelServiceHolder.get().save((Identifiable)encounter.get());
                    return "";
                }
            }
            catch (Exception e) {
                logger.debug("Could not resolve TI Code [" + makro + "]");
            }
        }
        return null;
    }
}

