/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.TarmedRechnung;

import ch.elexis.TarmedRechnung.Messages;
import ch.elexis.TarmedRechnung.XMLExporter;
import ch.elexis.TarmedRechnung.XMLExporterServices;
import ch.elexis.TarmedRechnung.XMLExporterUtil;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IMandator;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.XMLTool;
import java.util.Arrays;
import org.jdom2.Content;
import org.jdom2.Element;

public class XMLExporterBalance {
    private static final String ATTR_AMOUNT_OBLIGATIONS = "amount_obligations";
    private Element balanceElement;
    private Money mDue;
    private Money mAmount = new Money();

    public XMLExporterBalance(Element balance) {
        this.balanceElement = balance;
    }

    public Money getDue() {
        if (this.mDue == null) {
            String attrValue = this.balanceElement.getAttributeValue("amount_due");
            this.mDue = attrValue != null && !attrValue.isEmpty() ? XMLTool.xmlDoubleToMoney((String)attrValue) : new Money();
        }
        return this.mDue;
    }

    public void setDue(Money money) {
        this.mDue = money;
        this.balanceElement.setAttribute("amount_due", XMLTool.moneyToXmlDouble((Money)this.mDue));
    }

    public Money getAmount() {
        String attrValue = this.balanceElement.getAttributeValue("amount");
        this.mAmount = attrValue != null && !attrValue.isEmpty() ? XMLTool.xmlDoubleToMoney((String)attrValue) : new Money();
        return this.mAmount;
    }

    public void setAmount(Money money) {
        this.balanceElement.setAttribute("amount", XMLTool.moneyToXmlDouble((Money)money));
    }

    public Money getAmountObligations() {
        String attrValue = this.balanceElement.getAttributeValue(ATTR_AMOUNT_OBLIGATIONS);
        if (attrValue != null && !attrValue.isEmpty()) {
            return XMLTool.xmlDoubleToMoney((String)attrValue);
        }
        return new Money();
    }

    public Money getReminder() {
        String attrValue = this.balanceElement.getAttributeValue("amount_reminder");
        if (attrValue != null && !attrValue.isEmpty()) {
            return XMLTool.xmlDoubleToMoney((String)attrValue);
        }
        return new Money();
    }

    public Money getPrepaid() {
        String attrValue = this.balanceElement.getAttributeValue("amount_prepaid");
        if (attrValue != null && !attrValue.isEmpty()) {
            return XMLTool.xmlDoubleToMoney((String)attrValue);
        }
        return new Money();
    }

    public void setPrepaid(Money money) {
        this.balanceElement.setAttribute("amount_prepaid", XMLTool.moneyToXmlDouble((Money)money));
    }

    public boolean hasPrepaid() {
        String attrValue = this.balanceElement.getAttributeValue("amount_prepaid");
        return attrValue != null && !attrValue.isEmpty();
    }

    public Element getElement() {
        return this.balanceElement;
    }

    public void negateAmount() {
        XMLExporterUtil.negate(this.balanceElement, "amount");
    }

    public void negateAmountObligations() {
        XMLExporterUtil.negate(this.balanceElement, ATTR_AMOUNT_OBLIGATIONS);
    }

    public static XMLExporterBalance buildBalance(IInvoice invoice, XMLExporterServices services, XMLExporter.VatRateSum vatSummer, XMLExporter xmlExporter) {
        IMandator actMandant = invoice.getMandator();
        Money reminders = invoice.getDemandAmount();
        Element element = new Element("balance", XMLExporter.nsinvoice);
        XMLExporterBalance balance = new XMLExporterBalance(element);
        String curr = (String)actMandant.getBiller().getExtInfo((Object)Messages.XMLExporter_Currency);
        if (StringTool.isNothing((Object)curr)) {
            curr = "CHF";
        }
        element.setAttribute("currency", curr);
        balance.mAmount.addMoney(services.getTarmedMoney()).addMoney(services.getAnalysenMoney()).addMoney(services.getMedikamentMoney()).addMoney(services.getUebrigeMoney()).addMoney(services.getKantMoney()).addMoney(services.getPhysioMoney()).addMoney(services.getMigelMoney());
        element.setAttribute("amount_prepaid", XMLTool.moneyToXmlDouble((Money)new Money(invoice.getPayedAmount())));
        if (!reminders.isZero()) {
            element.setAttribute("amount_reminder", XMLTool.moneyToXmlDouble((Money)reminders));
        }
        element.setAttribute("amount", XMLTool.moneyToXmlDouble((Money)balance.mAmount));
        balance.mDue = new Money(balance.mAmount);
        if (!reminders.isZero()) {
            balance.mDue.addMoney(reminders);
        }
        balance.mDue.subtractMoney(invoice.getPayedAmount());
        balance.mDue.roundTo5();
        element.setAttribute("amount_due", XMLTool.moneyToXmlDouble((Money)balance.mDue));
        element.setAttribute(ATTR_AMOUNT_OBLIGATIONS, XMLTool.moneyToXmlDouble((Money)services.getObligationsMoney()));
        Element vat = new Element("vat", XMLExporter.nsinvoice);
        String vatNumber = (String)actMandant.getBiller().getExtInfo((Object)"at.medevit.medelexis.vat_ch/MandantVatNumber");
        if (vatNumber != null && vatNumber.length() > 0) {
            vat.setAttribute("vat_number", vatNumber);
        }
        vat.setAttribute("vat", XMLTool.doubleToXmlDouble((double)vatSummer.sumvat, (int)2));
        Object[] vatValues = vatSummer.rates.values().toArray(new XMLExporter.VatRateSum.VatRateElement[0]);
        Arrays.sort(vatValues);
        Object[] objectArray = vatValues;
        int n = vatValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object rate = objectArray[n2];
            Element vatrate = new Element("vat_rate", XMLExporter.nsinvoice);
            vatrate.setAttribute("vat_rate", XMLTool.doubleToXmlDouble((double)((XMLExporter.VatRateSum.VatRateElement)rate).scale, (int)2));
            vatrate.setAttribute("amount", XMLTool.doubleToXmlDouble((double)((XMLExporter.VatRateSum.VatRateElement)rate).sumamount, (int)2));
            vatrate.setAttribute("vat", XMLTool.doubleToXmlDouble((double)((XMLExporter.VatRateSum.VatRateElement)rate).sumvat, (int)2));
            vat.addContent((Content)vatrate);
            ++n2;
        }
        element.addContent((Content)vat);
        return balance;
    }
}

