/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.TarmedRechnung;

import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.InvoiceState;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Document;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.LoggerFactory;

public class XMLFileUtil {
    public static Optional<String> getFileName(IInvoice invoice, String outputDir) {
        if (invoice != null && StringUtils.isNotBlank((CharSequence)outputDir)) {
            return XMLFileUtil.getFileName("", invoice, outputDir);
        }
        return Optional.empty();
    }

    private static Optional<String> getFileName(String timestamp, IInvoice invoice, String outputDir) {
        StringBuilder fname = new StringBuilder(outputDir + (outputDir.endsWith(File.separator) ? "" : File.separator));
        fname.append(invoice.getNumber());
        fname.append(XMLFileUtil.getFilenameAppendix(invoice.getState()));
        if (StringUtils.isNotBlank((CharSequence)timestamp)) {
            fname.append("_" + timestamp);
        }
        fname.append(".xml");
        File file = new File(fname.toString());
        if (file.exists()) {
            return XMLFileUtil.getFileName(Long.toString(System.currentTimeMillis()), invoice, outputDir);
        }
        return Optional.of(fname.toString());
    }

    private static String getFilenameAppendix(InvoiceState state) {
        if (state == InvoiceState.DEMAND_NOTE_1 || state == InvoiceState.DEMAND_NOTE_1_PRINTED) {
            return "_m1";
        }
        if (state == InvoiceState.DEMAND_NOTE_2 || state == InvoiceState.DEMAND_NOTE_2_PRINTED) {
            return "_m2";
        }
        if (state == InvoiceState.DEMAND_NOTE_3 || state == InvoiceState.DEMAND_NOTE_3_PRINTED) {
            return "_m3";
        }
        if (state == InvoiceState.CANCELLED) {
            return "_storno";
        }
        return "";
    }

    public static void writeToFile(String filename, Document document) {
        File xmlOutput = new File(filename);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileWriter writer = new FileWriter(xmlOutput);){
                writer.write(XMLFileUtil.getAsString(document));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(XMLFileUtil.class).error("Could not write [" + xmlOutput.getAbsolutePath() + "]", (Throwable)e);
        }
        LoggerFactory.getLogger(XMLFileUtil.class).info("Wrote [" + xmlOutput.getAbsolutePath() + "] with size [" + xmlOutput.length() + "]");
    }

    public static String getAsString(Document document) {
        try {
            StringWriter stringWriter = new StringWriter();
            XMLOutputter xout = new XMLOutputter(Format.getPrettyFormat());
            xout.output(document, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (IOException e) {
            LoggerFactory.getLogger(XMLFileUtil.class).error("Error creating string from invoice", (Throwable)e);
            return null;
        }
    }

    public static File moveToArchive(File file, File archiveDir) {
        File destFile = new File(archiveDir, file.getName());
        if (destFile.exists()) {
            destFile = new File(archiveDir, XMLFileUtil.addTimestamp(file.getName()));
        }
        Path src = file.toPath();
        Path dest = destFile.toPath();
        try {
            Files.move(src, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(XMLFileUtil.class).error("Error moving [" + file.getAbsolutePath() + "] to archive [" + archiveDir.getAbsolutePath() + "]");
        }
        return destFile;
    }

    private static String addTimestamp(String filename) {
        return FilenameUtils.getBaseName((String)filename) + "_" + Long.toString(System.currentTimeMillis()) + "." + FilenameUtils.getExtension((String)filename);
    }

    public static Optional<File> lookupFile(String outputDir, IInvoice invoice, LocalDateTime timestamp, InvoiceState invoiceState) {
        List invoiceFiles;
        File directory;
        if (StringUtils.isNotBlank((CharSequence)outputDir) && (directory = new File(outputDir)).exists() && directory.isDirectory() && !(invoiceFiles = Arrays.asList(directory.listFiles()).stream().filter(f -> f.getName().toLowerCase().startsWith(invoice.getNumber() + "_") || f.getName().toLowerCase().startsWith(invoice.getNumber() + ".")).collect(Collectors.toList())).isEmpty()) {
            if (invoiceFiles.size() > 1) {
                List filteredInvoiceFiles = new ArrayList(invoiceFiles);
                if (invoiceState != null && StringUtils.isNotBlank((CharSequence)XMLFileUtil.getFilenameAppendix(invoiceState))) {
                    filteredInvoiceFiles = filteredInvoiceFiles.stream().filter(f -> f.getName().toLowerCase().contains("_" + XMLFileUtil.getFilenameAppendix(invoiceState))).collect(Collectors.toList());
                }
                if (filteredInvoiceFiles.size() > 1 && timestamp != null) {
                    filteredInvoiceFiles = filteredInvoiceFiles.stream().filter(f -> Math.abs(ChronoUnit.SECONDS.between(LocalDateTime.ofInstant(Instant.ofEpochMilli(f.lastModified()), TimeZone.getDefault().toZoneId()), timestamp)) < 5L).collect(Collectors.toList());
                }
                if (filteredInvoiceFiles.size() == 1) {
                    return Optional.of((File)filteredInvoiceFiles.get(0));
                }
            }
            return Optional.of((File)invoiceFiles.get(0));
        }
        return Optional.empty();
    }
}

