/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.views;

import ch.elexis.base.ch.arzttarife.tardoc.ITardocLeistung;
import ch.elexis.base.ch.arzttarife.tarmed.ITarmedLeistung;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.builder.IBilledBuilder;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.icons.Images;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class ArzttarifRefcodesDialog
extends Dialog {
    private IBilled billed;
    private Composite contentComposite;
    private List<RefCodeEditComposite> refcodesComposites = new ArrayList<RefCodeEditComposite>();

    public ArzttarifRefcodesDialog(Shell shell, IBilled tl) {
        super(shell);
        this.billed = tl;
    }

    protected Control createDialogArea(Composite parent) {
        this.contentComposite = (Composite)super.createDialogArea(parent);
        this.contentComposite.setLayout((Layout)new GridLayout(2, false));
        Label lbl = new Label(this.contentComposite, 0);
        lbl.setText(this.billed.getAmount() + "x " + this.billed.getText());
        lbl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        lbl = new Label(this.contentComposite, 0);
        lbl.setText("Aufteilen zu Bezugsleistungen (selber Fall und selber Tag)");
        lbl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ToolBarManager mgr = new ToolBarManager(0x820000);
        mgr.add((IAction)new Action(){

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_NEW.getImageDescriptor();
            }

            public void run() {
                ArzttarifRefcodesDialog.this.addRefcodeEdit();
            }
        });
        mgr.createControl(this.contentComposite);
        return this.contentComposite;
    }

    private void addRefcodeEdit() {
        RefCodeEditComposite add = new RefCodeEditComposite(this.contentComposite, 0);
        add.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        this.refcodesComposites.add(add);
        this.getShell().pack(true);
    }

    private void removeRefcodeEdit(RefCodeEditComposite refCodeEditComposite) {
        ((GridData)refCodeEditComposite.getLayoutData()).exclude = true;
        refCodeEditComposite.setVisible(false);
        refCodeEditComposite.dispose();
        this.refcodesComposites.remove((Object)refCodeEditComposite);
        this.getShell().pack(true);
    }

    public void create() {
        super.create();
        this.getShell().setText(this.billed.getBillable().getCodeSystemName() + "-Bez\u00fcge herstellen: " + this.billed.getCode());
    }

    protected void okPressed() {
        if (!this.refcodesComposites.isEmpty()) {
            if (this.isValid()) {
                this.refcodesComposites.forEach(rc -> rc.apply(this.billed));
                ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)this.billed.getEncounter());
                super.okPressed();
            } else {
                MessageDialog.openWarning((Shell)this.getShell(), (String)"Warnung", (String)"Summe der Bez\u00fcge ist gr\u00f6sser als die urspr\u00fcngliche Menge.");
            }
        }
    }

    private boolean isValid() {
        return (double)this.refcodesComposites.stream().mapToInt(rc -> rc.amountSpinner.getSelection()).sum() <= this.billed.getAmount();
    }

    public static boolean isArzttarif(IBillable billable) {
        return billable instanceof ITardocLeistung || billable instanceof ITarmedLeistung;
    }

    private class RefCodeEditComposite
    extends Composite {
        private ComboViewer refcodeCombo;
        private Spinner amountSpinner;

        public RefCodeEditComposite(Composite parent, int style) {
            super(parent, style);
            this.setLayout((Layout)new GridLayout(3, false));
            this.createContent();
        }

        public void apply(IBilled billed) {
            if (this.amountSpinner.getSelection() > 0 && !this.refcodeCombo.getSelection().isEmpty()) {
                String bezug = (String)((StructuredSelection)this.refcodeCombo.getSelection()).getFirstElement();
                int amount = this.amountSpinner.getSelection();
                if ((double)amount == billed.getAmount()) {
                    billed.setExtInfo((Object)"Bezug", (Object)bezug);
                    CoreModelServiceHolder.get().save((Identifiable)billed);
                } else {
                    IContact biller = (IContact)ContextServiceHolder.get().getActiveUserContact().get();
                    IBilled copy = (IBilled)new IBilledBuilder(CoreModelServiceHolder.get(), billed.getBillable(), billed.getEncounter(), biller).build();
                    billed.copy(copy);
                    copy.setAmount((double)amount);
                    billed.setAmount(billed.getAmount() - (double)amount);
                    copy.setExtInfo((Object)"Bezug", (Object)bezug);
                    CoreModelServiceHolder.get().save(Arrays.asList(billed, copy));
                }
            }
        }

        private void createContent() {
            this.refcodeCombo = new ComboViewer((Composite)this, 2048);
            this.refcodeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.refcodeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.refcodeCombo.setInput(this.getPossibleRefCodes());
            this.amountSpinner = new Spinner((Composite)this, 2048);
            this.amountSpinner.setValues(0, 0, (int)ArzttarifRefcodesDialog.this.billed.getAmount(), 0, 1, 1);
            ToolBarManager mgr = new ToolBarManager(0x820000);
            mgr.add((IAction)new Action(){

                public ImageDescriptor getImageDescriptor() {
                    return Images.IMG_DELETE.getImageDescriptor();
                }

                public void run() {
                    ArzttarifRefcodesDialog.this.removeRefcodeEdit(RefCodeEditComposite.this);
                }
            });
            mgr.createControl((Composite)this);
        }

        private List<String> getPossibleRefCodes() {
            IEncounter encounter = ArzttarifRefcodesDialog.this.billed.getEncounter();
            IQuery query = CoreModelServiceHolder.get().getQuery(IEncounter.class);
            query.and((EStructuralFeature)ModelPackage.Literals.IENCOUNTER__COVERAGE, IQuery.COMPARATOR.EQUALS, (Object)encounter.getCoverage());
            query.and((EStructuralFeature)ModelPackage.Literals.IENCOUNTER__DATE, IQuery.COMPARATOR.EQUALS, (Object)encounter.getDate());
            List encounters = query.execute();
            if (!encounters.isEmpty()) {
                ArrayList<String> ret = new ArrayList<String>();
                HashSet uniqueCodes = new HashSet();
                Class<?> billableClazz = ArzttarifRefcodesDialog.this.billed.getBillable().getClass();
                encounters.forEach(e -> {
                    List codes = e.getBilled().stream().filter(b -> billableClazz.isInstance(b.getBillable())).map(b -> b.getCode()).collect(Collectors.toList());
                    uniqueCodes.addAll(codes);
                });
                ret.addAll(uniqueCodes);
                Collections.sort(ret);
                return ret;
            }
            return Collections.emptyList();
        }
    }
}

